/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.ProfileBuilder;
import org.apache.karaf.profile.ProfileMBean;
import org.apache.karaf.profile.ProfileService;
import org.apache.karaf.profile.impl.Utils;

public class ProfileMBeanImpl
extends StandardMBean
implements ProfileMBean {
    private ProfileService profileService;

    public ProfileMBeanImpl() throws NotCompliantMBeanException {
        super(ProfileMBean.class);
    }

    @Override
    public Map<String, String> getProfiles() {
        ArrayList<String> ids = new ArrayList<String>(this.profileService.getProfiles());
        HashMap<String, String> results = new HashMap<String, String>();
        Collections.sort(ids);
        for (String id : ids) {
            Profile profile = this.profileService.getProfile(id);
            if (profile == null) continue;
            String parents = Utils.join(" ", profile.getParentIds());
            results.put(id, parents);
        }
        return results;
    }

    @Override
    public void rename(String name, String newName) {
        Profile profile = ProfileBuilder.Factory.createFrom(this.profileService.getProfile(name)).identity(newName).getProfile();
        this.profileService.createProfile(profile);
        this.profileService.deleteProfile(name);
    }

    @Override
    public void delete(String name) {
        this.profileService.deleteProfile(name);
    }

    @Override
    public void create(String name, List<String> parents) {
        Profile profile = ProfileBuilder.Factory.create(name).setParents(parents).getProfile();
        this.profileService.createProfile(profile);
    }

    @Override
    public void copy(String source, String target) {
        Profile profile = ProfileBuilder.Factory.createFrom(this.profileService.getProfile(source)).identity(target).getProfile();
        this.profileService.createProfile(profile);
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }
}

