/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.store.intern;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ops4j.store.Handle;
import org.ops4j.store.Store;
import org.ops4j.store.StoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryStore
implements Store<InputStream> {
    public static final String FILENAME_PREFIX = "ops4jstore-";
    public static final String FILENAME_SUFFIX = ".bin";
    private static Logger LOG = LoggerFactory.getLogger(TemporaryStore.class);
    private final File m_dir;

    public TemporaryStore(File folder, boolean flushStoreage) {
        this.m_dir = folder;
        if (this.m_dir.exists() && flushStoreage) {
            this.delete(this.m_dir);
        }
        this.m_dir.mkdirs();
        this.m_dir.deleteOnExit();
        LOG.debug("Storage Area is " + this.m_dir.getAbsolutePath());
    }

    @Override
    public Handle store(InputStream inp) throws IOException {
        LOG.debug("Enter store()");
        File intermediate = File.createTempFile(FILENAME_PREFIX, ".tmp");
        intermediate.deleteOnExit();
        FileOutputStream fis = new FileOutputStream(intermediate);
        final String h = this.hash(inp, fis);
        fis.close();
        if (!this.getLocation(h).exists()) {
            Files.copy(intermediate.toPath(), new FileOutputStream(this.getLocation(h)));
        } else {
            LOG.debug("Object for " + h + " already exists in store.");
        }
        intermediate.delete();
        Handle handle = new Handle(){

            @Override
            public String getIdentification() {
                return h;
            }
        };
        LOG.debug("Exit store(): " + h);
        return handle;
    }

    private File getLocation(String id) {
        File file = new File(this.m_dir, this.getFileName(id));
        file.deleteOnExit();
        return file;
    }

    private String getFileName(String id) {
        return FILENAME_PREFIX + id + FILENAME_SUFFIX;
    }

    @Override
    public InputStream load(Handle handle) throws IOException {
        return new FileInputStream(this.getLocation(handle.getIdentification()));
    }

    @Override
    public URI getLocation(Handle handle) throws IOException {
        return this.getLocation(handle.getIdentification()).toURI();
    }

    public String hash(InputStream is, OutputStream storeHere) throws IOException {
        byte[] sha1hash;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] bytes = new byte[1024];
            int numRead = 0;
            while ((numRead = is.read(bytes)) >= 0) {
                md.update(bytes, 0, numRead);
                storeHere.write(bytes, 0, numRead);
            }
            sha1hash = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return StoreFactory.convertToHex(sha1hash);
    }

    private boolean delete(File file) {
        File[] childs;
        boolean delete = false;
        if (file != null && file.exists() && !(delete = file.delete()) && file.isDirectory() && (childs = file.listFiles()) != null && childs.length > 0) {
            for (File child : childs) {
                this.delete(child);
            }
            delete = file.delete();
        }
        return delete;
    }
}

