/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.api;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.SinkModule;

public interface MessageConsumerManager {
    public static final String LOG_PREFIX = "ipc";
    public static final String METRIC_MESSAGES_RECEIVED = "messagesReceived";
    public static final String METRIC_MESSAGE_SIZE = "messageSize";
    public static final String METRIC_DISPATCH_TIME = "dispatchTime";

    public <S extends Message, T extends Message> void dispatch(SinkModule<S, T> var1, T var2);

    public <S extends Message, T extends Message> void registerConsumer(MessageConsumer<S, T> var1) throws Exception;

    public <S extends Message, T extends Message> void unregisterConsumer(MessageConsumer<S, T> var1) throws Exception;

    public static void updateMessageSize(MetricRegistry metricRegistry, String location, String moduleId, int messageSize) {
        Histogram messageSizeHistogram = metricRegistry.histogram(MetricRegistry.name((String)location, (String[])new String[]{moduleId, METRIC_MESSAGE_SIZE}));
        messageSizeHistogram.update(messageSize);
    }

    public static Timer getDispatchTimerMetric(MetricRegistry metricRegistry, String location, String moduleId) {
        return metricRegistry.timer(MetricRegistry.name((String)location, (String[])new String[]{moduleId, METRIC_DISPATCH_TIME}));
    }
}

