/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.NativeSelect;
import com.vaadin.v7.ui.Table;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.opennms.features.topology.api.HasExtraComponents;
import org.opennms.features.topology.api.browsers.OnmsVaadinContainer;
import org.opennms.features.topology.api.browsers.SelectionAwareTable;
import org.opennms.features.topology.plugins.browsers.CheckboxGenerator;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.osgi.EventProxy;
import org.opennms.osgi.VaadinApplicationContext;
import org.opennms.osgi.VaadinApplicationContextAware;
import org.springframework.security.core.context.SecurityContextHolder;

public class AlarmTable
extends SelectionAwareTable
implements HasExtraComponents,
VaadinApplicationContextAware {
    private static final String ACTION_CLEAR = "Clear";
    private static final String ACTION_ESCALATE = "Escalate";
    private static final String ACTION_UNACKNOWLEDGE = "Unacknowledge";
    private static final String ACTION_ACKNOWLEDGE = "Acknowledge";
    private static final long serialVersionUID = -1384405693333129773L;
    private EventProxy m_eventProxy;
    private VaadinApplicationContext vaadinApplicationContext;
    private final CheckboxButton m_submitButton;
    private final NativeSelect m_ackCombo;
    private final SelectAllButton m_selectAllButton = new SelectAllButton("Select All");
    private final ResetSelectionButton m_resetButton = new ResetSelectionButton("Deselect All");
    private final AlarmRepository m_alarmRepo;
    private Set<Container.ItemSetChangeListener> m_itemSetChangeListeners = new HashSet<Container.ItemSetChangeListener>();

    public AlarmTable(String caption, OnmsVaadinContainer container, AlarmRepository alarmRepo) {
        super(caption, container);
        this.m_alarmRepo = alarmRepo;
        this.m_ackCombo = new NativeSelect();
        this.m_ackCombo.setNullSelectionAllowed(false);
        this.m_ackCombo.addItem((Object)ACTION_ACKNOWLEDGE);
        this.m_ackCombo.addItem((Object)ACTION_UNACKNOWLEDGE);
        this.m_ackCombo.addItem((Object)ACTION_ESCALATE);
        this.m_ackCombo.addItem((Object)ACTION_CLEAR);
        this.m_ackCombo.setValue((Object)ACTION_ACKNOWLEDGE);
        this.m_submitButton = new CheckboxButton("Submit");
        this.m_submitButton.setCombo((AbstractSelect)this.m_ackCombo);
    }

    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        for (Container.ItemSetChangeListener listener : this.m_itemSetChangeListeners) {
            listener.containerItemSetChange(event);
        }
        super.containerItemSetChange(event);
    }

    public void setColumnGenerators(Map generators) {
        super.setColumnGenerators(generators);
        for (Object key : generators.keySet()) {
            try {
                Object generatorObj = generators.get(key);
                CheckboxGenerator generator = (CheckboxGenerator)generatorObj;
                this.m_submitButton.setCheckboxGenerator(generator);
                this.m_selectAllButton.setCheckboxGenerator(generator);
                this.m_resetButton.setCheckboxGenerator(generator);
                this.m_itemSetChangeListeners.add(generator);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    public Component[] getExtraComponents() {
        if (SecurityContextHolder.getContext().toString().contains("ROLE_READONLY")) {
            return new Component[0];
        }
        return new Component[]{this.m_selectAllButton, this.m_resetButton, this.m_ackCombo, this.m_submitButton};
    }

    public void setVaadinApplicationContext(VaadinApplicationContext vaadinApplicationContext) {
        this.vaadinApplicationContext = vaadinApplicationContext;
    }

    private String getUser() {
        return this.vaadinApplicationContext.getUsername();
    }

    private class SelectAllButton
    extends Button {
        private CheckboxGenerator m_generator;

        public SelectAllButton(String string) {
            super(string);
            this.setStyleName("link");
            this.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    SelectAllButton.this.m_generator.selectAll((Table)AlarmTable.this);
                }
            });
        }

        public void setCheckboxGenerator(CheckboxGenerator generator) {
            this.m_generator = generator;
        }
    }

    private class ResetSelectionButton
    extends Button {
        private CheckboxGenerator m_generator;

        public ResetSelectionButton(String string) {
            super(string);
            this.setStyleName("link");
            this.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    ResetSelectionButton.this.m_generator.clearSelectedIds((Table)AlarmTable.this);
                }
            });
        }

        public void setCheckboxGenerator(CheckboxGenerator generator) {
            this.m_generator = generator;
        }
    }

    private class CheckboxButton
    extends Button {
        private static final long serialVersionUID = -3595363303361200441L;
        private CheckboxGenerator m_generator;
        private AbstractSelect m_ackCombo;

        public CheckboxButton(String string) {
            super(string);
            AlarmTable.this.setColumnCollapsingAllowed(false);
            this.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 4351558084135658129L;

                public void buttonClick(Button.ClickEvent event) {
                    Set<Integer> selected = CheckboxButton.this.m_generator.getSelectedIds((Table)AlarmTable.this);
                    if (selected.size() > 0) {
                        String action = (String)CheckboxButton.this.m_ackCombo.getValue();
                        if (AlarmTable.ACTION_ACKNOWLEDGE.equals(action)) {
                            AlarmTable.this.m_alarmRepo.acknowledgeAlarms(ArrayUtils.toPrimitive((Integer[])selected.toArray(new Integer[0])), AlarmTable.this.getUser(), new Date());
                        } else if (AlarmTable.ACTION_UNACKNOWLEDGE.equals(action)) {
                            AlarmTable.this.m_alarmRepo.unacknowledgeAlarms(ArrayUtils.toPrimitive((Integer[])selected.toArray(new Integer[0])), AlarmTable.this.getUser());
                        } else if (AlarmTable.ACTION_ESCALATE.equals(action)) {
                            AlarmTable.this.m_alarmRepo.escalateAlarms(ArrayUtils.toPrimitive((Integer[])selected.toArray(new Integer[0])), AlarmTable.this.getUser(), new Date());
                        } else if (AlarmTable.ACTION_CLEAR.equals(action)) {
                            AlarmTable.this.m_alarmRepo.clearAlarms(ArrayUtils.toPrimitive((Integer[])selected.toArray(new Integer[0])), AlarmTable.this.getUser(), new Date());
                        }
                        CheckboxButton.this.m_generator.clearSelectedIds((Table)AlarmTable.this);
                        AlarmTable.this.containerItemSetChange(new Container.ItemSetChangeEvent(){
                            private static final long serialVersionUID = 7086486972418241175L;

                            public Container getContainer() {
                                return AlarmTable.this.getContainerDataSource();
                            }
                        });
                    }
                }
            });
        }

        public void setCombo(AbstractSelect combo) {
            this.m_ackCombo = combo;
        }

        public void setCheckboxGenerator(CheckboxGenerator generator) {
            this.m_generator = generator;
        }
    }
}

