/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.browsers;

import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;

public class AlarmCellStyleRenderer {
    public String getStyle(Integer severityObject, boolean acknowledged) {
        int severity = severityObject == null ? OnmsSeverity.INDETERMINATE.getId() : severityObject.intValue();
        StringBuilder retVal = new StringBuilder();
        if (OnmsSeverity.CLEARED.getId() != severity) {
            if (OnmsSeverity.CRITICAL.getId() == severity) {
                retVal.append("alarm-critical");
            } else if (OnmsSeverity.INDETERMINATE.getId() == severity) {
                retVal.append("alarm-indeterminate");
            } else if (OnmsSeverity.MAJOR.getId() == severity) {
                retVal.append("alarm-major");
            } else if (OnmsSeverity.MINOR.getId() == severity) {
                retVal.append("alarm-minor");
            } else if (OnmsSeverity.NORMAL.getId() == severity) {
                retVal.append("alarm-normal");
            } else if (OnmsSeverity.WARNING.getId() == severity) {
                retVal.append("alarm-warning");
            }
        }
        if (!acknowledged) {
            retVal.append("-noack");
        }
        return retVal.toString();
    }

    public String getStyle(OnmsAlarm alarm) {
        if (alarm == null) {
            return this.getStyle(null, false);
        }
        return this.getStyle(alarm.getSeverityId(), alarm.isAcknowledged());
    }
}

