/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.reporting.repository.local;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.beanutils.BeanUtils;
import org.opennms.features.reporting.dao.LocalReportsDao;
import org.opennms.features.reporting.dao.jasper.LocalJasperReportsDao;
import org.opennms.features.reporting.model.basicreport.BasicReportDefinition;
import org.opennms.features.reporting.model.basicreport.LegacyLocalReportDefinition;
import org.opennms.features.reporting.repository.ReportRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class LegacyLocalReportRepository
implements ReportRepository {
    private Logger logger = LoggerFactory.getLogger(LegacyLocalReportRepository.class);
    private LocalReportsDao m_localReportsDao;
    private LocalJasperReportsDao m_localJasperReportsDao;
    private static final String REPOSITORY_ID = "local";
    private static final String REPOSITORY_NAME = "Local Report Repository";
    private static final String REPOSITORY_DESCRIPTION = "Providing OpenNMS community reports from local disk.";
    private static final String MANAGEMENT_URL = "blank";

    public LegacyLocalReportRepository(LocalReportsDao localReportsDao, LocalJasperReportsDao localJasperReportsDao) {
        this.m_localReportsDao = localReportsDao;
        Assert.notNull((Object)this.m_localReportsDao, (String)"property configResource must be set to a non-null value");
        this.logger.debug("Config resource is set to '{}'", (Object)this.m_localReportsDao.toString());
        this.m_localJasperReportsDao = localJasperReportsDao;
        Assert.notNull((Object)this.m_localJasperReportsDao, (String)"property configResource must be set to a non-null value");
        this.logger.debug("Config resource is set to '{}'", (Object)this.m_localJasperReportsDao.toString());
    }

    @Override
    public List<BasicReportDefinition> getReports() {
        ArrayList<BasicReportDefinition> resultList = new ArrayList<BasicReportDefinition>();
        for (BasicReportDefinition report : this.m_localReportsDao.getReports()) {
            LegacyLocalReportDefinition resultReport = new LegacyLocalReportDefinition();
            try {
                BeanUtils.copyProperties((Object)resultReport, (Object)report);
                resultReport.setId("local_" + report.getId());
                resultReport.setAllowAccess(true);
            }
            catch (IllegalAccessException e) {
                this.logger.error("IllegalAccessException during BeanUtils.copyProperties for BasicReportDefinion '{}'", (Object)e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.logger.error("InvocationTargetException during BeanUtils.copyProperties for BasicReportDefinion '{}'", (Object)e.getMessage());
                e.printStackTrace();
            }
            resultList.add((BasicReportDefinition)resultReport);
        }
        return resultList;
    }

    @Override
    public List<BasicReportDefinition> getOnlineReports() {
        ArrayList<BasicReportDefinition> resultList = new ArrayList<BasicReportDefinition>();
        for (BasicReportDefinition report : this.m_localReportsDao.getOnlineReports()) {
            LegacyLocalReportDefinition resultReport = new LegacyLocalReportDefinition();
            try {
                BeanUtils.copyProperties((Object)resultReport, (Object)report);
                resultReport.setId("local_" + report.getId());
                resultReport.setAllowAccess(true);
            }
            catch (IllegalAccessException e) {
                this.logger.error("IllegalAccessException during BeanUtils.copyProperties for BasicReportDefinion '{}'", (Object)e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.logger.error("InvocationTargetException during BeanUtils.copyProperties for BasicReportDefinion '{}'", (Object)e.getMessage());
                e.printStackTrace();
            }
            resultList.add((BasicReportDefinition)resultReport);
        }
        return resultList;
    }

    @Override
    public String getReportService(String id) {
        id = id.substring(id.indexOf(95) + 1);
        return this.m_localReportsDao.getReportService(id);
    }

    @Override
    public String getDisplayName(String id) {
        id = id.substring(id.indexOf(95) + 1);
        return this.m_localReportsDao.getDisplayName(id);
    }

    @Override
    public String getEngine(String id) {
        id = id.substring(id.indexOf(95) + 1);
        return this.m_localJasperReportsDao.getEngine(id);
    }

    @Override
    public InputStream getTemplateStream(String id) {
        id = id.substring(id.indexOf(95) + 1);
        InputStream result = null;
        try {
            result = this.m_localJasperReportsDao.getTemplateStream(id);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getRepositoryId() {
        return REPOSITORY_ID;
    }

    @Override
    public String getRepositoryName() {
        return REPOSITORY_NAME;
    }

    @Override
    public String getRepositoryDescription() {
        return REPOSITORY_DESCRIPTION;
    }

    @Override
    public String getManagementUrl() {
        return MANAGEMENT_URL;
    }

    public void setLocalReportsDao(LocalReportsDao localReportsDao) {
        this.m_localReportsDao = localReportsDao;
    }

    public LocalReportsDao getLocalReportsDao() {
        return this.m_localReportsDao;
    }

    public void setLocalJasperReportsDao(LocalJasperReportsDao localJasperReportsDao) {
        this.m_localJasperReportsDao = localJasperReportsDao;
    }

    public LocalJasperReportsDao getLocalJasperReportsDao() {
        return this.m_localJasperReportsDao;
    }

    @Override
    public void loadConfiguration() {
        try {
            this.m_localReportsDao.loadConfiguration();
            this.m_localJasperReportsDao.loadConfiguration();
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(LegacyLocalReportRepository.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

