/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.dao.outages.impl;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.netmgt.config.BasicSchedule;
import org.opennms.netmgt.config.BasicScheduleUtils;
import org.opennms.netmgt.config.dao.outages.api.ReadablePollOutagesDao;
import org.opennms.netmgt.config.poller.outages.Interface;
import org.opennms.netmgt.config.poller.outages.Node;
import org.opennms.netmgt.config.poller.outages.Outage;
import org.opennms.netmgt.config.poller.outages.Outages;
import org.opennms.netmgt.config.poller.outages.Time;

public abstract class AbstractPollOutagesDao
implements ReadablePollOutagesDao {
    public static final String JSON_STORE_KEY = "poll-outages";
    final JsonStore jsonStore;

    public AbstractPollOutagesDao() {
        this.jsonStore = null;
        this.reload();
    }

    AbstractPollOutagesDao(JsonStore jsonStore) {
        this.jsonStore = Objects.requireNonNull(jsonStore);
    }

    public boolean isNodeIdInOutage(long lnodeid, String outName) {
        Outage out = ((Outages)this.getReadOnlyConfig()).getOutage(outName);
        if (out == null) {
            return false;
        }
        return this.isNodeIdInOutage(lnodeid, out);
    }

    public boolean isInterfaceInOutage(String linterface, String outName) {
        Outage out = ((Outages)this.getReadOnlyConfig()).getOutage(outName);
        if (out == null) {
            return false;
        }
        return this.isInterfaceInOutage(linterface, out);
    }

    public boolean isCurTimeInOutage(String outName) {
        return this.isTimeInOutage((Calendar)new GregorianCalendar(), outName);
    }

    public boolean isTimeInOutage(long time, String outName) {
        Outage out = ((Outages)this.getReadOnlyConfig()).getOutage(outName);
        if (out == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return this.isTimeInOutage(cal, out);
    }

    public String getOutageType(String name) {
        Outage out = ((Outages)this.getReadOnlyConfig()).getOutage(name);
        if (out == null) {
            return null;
        }
        return out.getType();
    }

    public List<Time> getOutageTimes(String name) {
        Outage out = ((Outages)this.getReadOnlyConfig()).getOutage(name);
        if (out == null) {
            return null;
        }
        return out.getTimes();
    }

    public List<Interface> getInterfaces(String name) {
        Outage out = ((Outages)this.getReadOnlyConfig()).getOutage(name);
        if (out == null) {
            return null;
        }
        return out.getInterfaces();
    }

    public boolean isTimeInOutage(Calendar cal, String outName) {
        Outage out = ((Outages)this.getReadOnlyConfig()).getOutage(outName);
        if (out == null) {
            return false;
        }
        return this.isTimeInOutage(cal, out);
    }

    public List<Node> getNodeIds(String name) {
        Outage out = ((Outages)this.getReadOnlyConfig()).getOutage(name);
        if (out == null) {
            return null;
        }
        return out.getNodes();
    }

    public Calendar getEndOfOutage(String outName) {
        Outage out = ((Outages)this.getReadOnlyConfig()).getOutage(outName);
        if (out == null) {
            return null;
        }
        return this.getEndOfOutage(out);
    }

    public boolean isInterfaceInOutage(String linterface, Outage out) {
        if (out == null) {
            return false;
        }
        for (Interface ointerface : out.getInterfaces()) {
            if (!ointerface.getAddress().equals("match-any") && !ointerface.getAddress().equals(linterface)) continue;
            return true;
        }
        return false;
    }

    public boolean isTimeInOutage(Calendar cal, Outage outage) {
        return BasicScheduleUtils.isTimeInSchedule((Calendar)cal, (BasicSchedule)BasicScheduleUtils.getBasicOutageSchedule((Outage)outage));
    }

    public boolean isCurTimeInOutage(Outage out) {
        return this.isTimeInOutage((Calendar)new GregorianCalendar(), out);
    }

    public Calendar getEndOfOutage(Outage out) {
        return BasicScheduleUtils.getEndOfSchedule((BasicSchedule)BasicScheduleUtils.getBasicOutageSchedule((Outage)out));
    }

    public boolean isNodeIdInOutage(long lnodeid, Outage out) {
        if (out == null) {
            return false;
        }
        for (Node onode : out.getNodes()) {
            if ((long)onode.getId().intValue() != lnodeid) continue;
            return true;
        }
        return false;
    }
}

