/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.Scope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingPollEvent
extends PollEvent {
    private static final Logger LOG = LoggerFactory.getLogger(PendingPollEvent.class);
    private static final long PENDING_EVENT_TIMEOUT = SystemProperties.getLong((String)"org.opennms.netmgt.poller.pendingEventTimeout", (Long)600000L);
    private IEvent m_event;
    private final Date m_date;
    private long m_expirationTimeInMillis;
    private final AtomicBoolean m_pending = new AtomicBoolean(true);
    private final Queue<Runnable> m_pendingOutages = new ConcurrentLinkedQueue<Runnable>();

    public PendingPollEvent(IEvent event) {
        super(Scope.fromUei(event.getUei()));
        this.m_event = event;
        this.m_date = this.m_event.getTime();
        this.m_expirationTimeInMillis = this.m_date.getTime() + PENDING_EVENT_TIMEOUT;
    }

    @Override
    public Date getDate() {
        return this.m_date;
    }

    @Override
    public long getEventId() {
        return this.m_event.getDbid();
    }

    public void addPending(Runnable r) {
        if (this.m_pending.get()) {
            this.m_pendingOutages.add(r);
        } else {
            r.run();
        }
    }

    public IEvent getEvent() {
        return this.m_event;
    }

    public boolean isPending() {
        if (this.m_pending.get() && this.isTimedOut()) {
            this.m_pending.set(false);
        }
        return this.m_pending.get();
    }

    boolean isTimedOut() {
        return System.currentTimeMillis() > this.m_expirationTimeInMillis;
    }

    public void complete(IEvent e) {
        this.m_event = e;
        this.m_pending.set(false);
    }

    public void processPending() {
        while (!this.m_pendingOutages.isEmpty()) {
            Runnable runnable = this.m_pendingOutages.poll();
            if (runnable != null) {
                runnable.run();
                continue;
            }
            return;
        }
    }

    public String toString() {
        return String.valueOf(this.m_event) + ", uei: " + this.m_event.getUei() + ", id: " + this.m_event.getDbid() + ", isPending: " + this.m_pending.get() + ", list size: " + this.m_pendingOutages.size();
    }

    void setExpirationTimeInMillis(long time) {
        this.m_expirationTimeInMillis = time;
    }
}

