/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.blockmodel;

import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VertexPartition<V, E> {
    private Map<V, Set<V>> vertex_partition_map;
    private Collection<Set<V>> vertex_sets;
    private Graph<V, E> graph;

    public VertexPartition(Graph<V, E> g, Map<V, Set<V>> partition_map) {
        this.vertex_partition_map = Collections.unmodifiableMap(partition_map);
        this.graph = g;
    }

    public VertexPartition(Graph<V, E> g, Map<V, Set<V>> partition_map, Collection<Set<V>> vertex_sets) {
        this.vertex_partition_map = Collections.unmodifiableMap(partition_map);
        this.vertex_sets = vertex_sets;
        this.graph = g;
    }

    public VertexPartition(Graph<V, E> g, Collection<Set<V>> vertex_sets) {
        this.vertex_sets = vertex_sets;
        this.graph = g;
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public Map<V, Set<V>> getVertexToPartitionMap() {
        if (this.vertex_partition_map == null) {
            this.vertex_partition_map = new HashMap<V, Set<V>>();
            for (Set<V> set : this.vertex_sets) {
                for (V v : set) {
                    this.vertex_partition_map.put((Set<V>)v, (Set<Set<V>>)set);
                }
            }
        }
        return this.vertex_partition_map;
    }

    public Collection<Set<V>> getVertexPartitions() {
        if (this.vertex_sets == null) {
            this.vertex_sets = new HashSet<Set<V>>();
            this.vertex_sets.addAll(this.vertex_partition_map.values());
        }
        return this.vertex_sets;
    }

    public int numPartitions() {
        return this.vertex_sets.size();
    }

    public String toString() {
        return "Partitions: " + this.vertex_partition_map;
    }
}

