<%--

    Licensed to The OpenNMS Group, Inc (TOG) under one or more
    contributor license agreements.  See the LICENSE.md file
    distributed with this work for additional information
    regarding copyright ownership.

    TOG licenses this file to You under the GNU Affero General
    Public License Version 3 (the "License") or (at your option)
    any later version.  You may not use this file except in
    compliance with the License.  You may obtain a copy of the
    License at:

         https://www.gnu.org/licenses/agpl-3.0.txt

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
    either express or implied.  See the License for the specific
    language governing permissions and limitations under the
    License.

--%>
<%@page language="java"
		contentType="text/html"
		session="true"
		import="java.util.*,
    org.opennms.core.utils.SIUtils,
    org.opennms.netmgt.model.OnmsNode,
    org.opennms.netmgt.model.OnmsResource,
    org.opennms.netmgt.dao.api.IfLabel,
    org.opennms.web.api.Authentication,
    org.opennms.web.element.*,
    org.opennms.netmgt.dao.hibernate.IfLabelDaoImpl"
%>
<%@ page import="org.opennms.netmgt.model.ResourceId" %>
<%@ page import="org.opennms.core.utils.WebSecurityUtils" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<%
  Interface intf_db = ElementUtil.getSnmpInterfaceByParams(request, getServletContext());
  int nodeId = intf_db.getNodeId();
  OnmsNode node = NetworkElementFactory.getInstance(getServletContext()).getNode(nodeId);
  String ipAddr = intf_db.getIpAddress();
	int ifIndex = -1;    
	if (intf_db.getSnmpIfIndex() > 0) {
		ifIndex = intf_db.getSnmpIfIndex();
	}
  String eventUrl2 = "event/list.htm?filter=node%3D" + nodeId + "&filter=ifindex%3D" + ifIndex;    
%>

<%@ page import="org.opennms.web.utils.Bootstrap" %>
<% Bootstrap.with(pageContext)
          .headTitle("Snmp Interface")
          .breadcrumb("Search", "element/index.jsp")
          .breadcrumb("Node", "element/node.jsp?node=" + nodeId)
          .breadcrumb("SnmpInterface")
          .build(request);
%>
<jsp:directive.include file="/includes/bootstrap.jsp" />

<%
if (request.isUserInRole( Authentication.ROLE_ADMIN )) {
%>

<script type="text/javascript" >
function doDelete() {
  if (confirm("Are you sure you want to proceed? This action will permanently delete this interface and cannot be undone.")) {
    document.forms["delete"].submit();
  }
  return false;
}
</script>

<%
}
%>

<h4>Interface: <%=(intf_db.getSnmpIfDescription() == null) ? "&nbsp;" : intf_db.getSnmpIfDescription()%></h4>

<%
if (request.isUserInRole( Authentication.ROLE_ADMIN )) {
%>
<form method="post" name="delete" action="admin/deleteInterface">
  <input type="hidden" name="node" value="<%=nodeId%>"/>
  <input type="hidden" name="ifindex" value="<%=(ifIndex == -1 ? "" : String.valueOf(ifIndex))%>"/>
  <input type="hidden" name="intf" value="<%=ipAddr%>"/>
<%
}
%>

<ul class="list-inline">
  <% if (ifIndex > 0 ) { %>
  	<li class="list-inline-item">
      <a href="<%=eventUrl2%>">View Events by ifIndex</a>
  	</li>
  <% } %>
  <%
    String ifLabel;
    if (ifIndex != -1) {
      // TODO In order to show the following link only when there are metrics, an inexpensive
      //      method has to be implemented on either ResourceService or ResourceDao
      ifLabel = IfLabelDaoImpl.getInstance().getIfLabelfromSnmpIfIndex(nodeId, ifIndex);
      ResourceId resourceId = ResourceId.get("node", Integer.toString(nodeId)).resolve("interfaceSnmp", ifLabel);
  %>
    <c:url var="graphLink" value="graph/results.htm">
      <c:param name="reports" value="all"/>
      <c:param name="resourceId" value="<%=resourceId.toString()%>"/>
    </c:url>
    <li class="list-inline-item">
      <a href="<c:out value="${graphLink}"/>">SNMP Interface Data Graphs</a>
    </li>
   <% 
    }
    if (request.isUserInRole( Authentication.ROLE_ADMIN )) { %>
    <li class="list-inline-item">
      <a href="admin/deleteInterface" onClick="return doDelete()">Delete</a>
    </li>
  <% } %>       
</ul>

<% if (request.isUserInRole( Authentication.ROLE_ADMIN )) { %>
</form>
<% } %>

<div class="row">

	<div class="col-md-6">

    <div class="card">
      <div class="card-header">
        <span>General</span>
      </div>
      <!-- general info box -->
      <table class="table table-sm">
        <tr>
          <th>Node</th>
          <td><a href="element/node.jsp?node=<%=intf_db.getNodeId()%>"><%=WebSecurityUtils.sanitizeString(node.getLabel())%></a></td>
        </tr>
        <tr>
          <th>Interface Index</th>
          <td>
            <% if( ifIndex != -1 ) {  %>
              <%=ifIndex%>
            <% } else { %>
              &nbsp;
            <% } %>
          </td>
        </tr>
        <tr>
          <th>Physical Address</th>
          <td>
            <% String macAddr = intf_db.getPhysicalAddress(); %>
            <% if( macAddr != null && macAddr.trim().length() > 0 && !macAddr.equals("000000000000")) { %>
              <%=macAddr%>
            <% } else { %>
              &nbsp;
            <% } %>
          </td>
        </tr>
        <% if( ipAddr != null && !ipAddr.equals("0.0.0.0")) { %>
        <tr>
          <th>IP Address</th>
          <td>
            <%=ipAddr%>
          </td>
        </tr>
        <% } %>
        <tr>
          <th>Last Snmp Table Scan</th>
          <td><%=intf_db.getSnmpLastCapsdPoll()%></td>
        </tr>
        <tr>
          <th>Snmp Polling Status</th>
          <td><%=ElementUtil.getSnmpInterfaceStatusString(intf_db)%></td>
        </tr>  
        <tr> 
          <th>Last Snmp Poll</th>
          <td><%=(intf_db.getSnmpLastSnmpPoll() == null) ? "&nbsp;" : intf_db.getSnmpLastSnmpPoll()%></td>
        </tr>              
      </table>
    </div>

    <!-- SNMP box, if info available -->
    <div class="card">
      <div class="card-header">
        <span>SNMP Attributes</span>
      </div>
    	<table class="table table-sm">
        <tr>
          <th>Interface Type</th>
          <td><%=ElementUtil.getIfTypeString(intf_db.getSnmpIfType())%></td>
        </tr>
        <tr> 
          <th>Status (Adm/Op)</th>
          <td>
            <% if( intf_db.getSnmpIfAdminStatus() < 1 || intf_db.getSnmpIfOperStatus() < 1 ) { %>
              &nbsp;
            <% } else { %>
              <%=ElementUtil.getIfStatusString(intf_db.getSnmpIfAdminStatus())%>/<%=ElementUtil.getIfStatusString(intf_db.getSnmpIfOperStatus())%>
            <% } %>
          </td>
        </tr>
        <tr>
          <th>Speed</th>
          <td><%=(intf_db.getSnmpIfSpeed() > 0) ? SIUtils.getHumanReadableIfSpeed(intf_db.getSnmpIfSpeed()) : "&nbsp;"%></td>
        </tr>
        <tr> 
          <th>Description</th>
          <td><%=(intf_db.getSnmpIfDescription() == null) ? "&nbsp;" : WebSecurityUtils.sanitizeString(intf_db.getSnmpIfDescription())%></td>
        </tr>
        <tr>
          <th>Alias</th>
          <td><%=(intf_db.getSnmpIfAlias() == null) ? "&nbsp;" : WebSecurityUtils.sanitizeString(intf_db.getSnmpIfAlias())%></td>
        </tr>
      </table>
    </div>

  </div> <!-- left content -->

  <div class="col-md-6">

    <!-- interface desktop information box -->
    <!-- events list box 2 using ifindex -->
    <% if (ifIndex > 0 ) { %>
      <% String eventHeader2 = "<a href='" + eventUrl2 + "'>Recent Events (Using Filter ifIndex = " + ifIndex + ")</a>"; %>
      <% String moreEventsUrl2 = eventUrl2; %>
      <jsp:include page="/includes/eventlist.jsp" flush="false" >
        <jsp:param name="node" value="<%=nodeId%>" />
        <jsp:param name="throttle" value="5" />
        <jsp:param name="header" value="<%=eventHeader2%>" />
        <jsp:param name="moreUrl" value="<%=moreEventsUrl2%>" />
        <jsp:param name="ifIndex" value="<%=ifIndex%>" />
      </jsp:include>
    <% } %>

  </div> <!-- right content -->

</div> <!-- row -->

<jsp:include page="/includes/bootstrap-footer.jsp" flush="false" />
