(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return (window["webpackJsonp"] = window["webpackJsonp"] || []).push([["timeline-resize"],{

/***/ "./src/main/assets/js/apps/timeline-resize/index.js":
/*!**********************************************************!*\
  !*** ./src/main/assets/js/apps/timeline-resize/index.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _parseFloat2 = _interopRequireDefault(__webpack_require__(/*! ../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/parse-float */ "./node_modules/@babel/runtime-corejs3/core-js-stable/parse-float.js"));
var _find = _interopRequireDefault(__webpack_require__(/*! ../../../../../../node_modules/@babel/runtime-corejs3/core-js-stable/instance/find */ "./node_modules/@babel/runtime-corejs3/core-js-stable/instance/find.js"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
var debounce = __webpack_require__(/*! ../../../../../../node_modules/lodash/lodash */ "./node_modules/lodash/lodash.js").debounce;
var DEBOUNCE_RATE = 200; // ms
var RELATIVE_SIZE = 0.5;
var getSize = function getSize(element) {
  // if we can get the offset width of the actual <td>, use it
  var td = element.closest('td')[0];
  if (td !== undefined) {
    // get the td's padding
    var s = getComputedStyle(td).padding;
    // remove 'px' from string like '4.8px' and convert to float
    var p = (0, _parseFloat2.default)(s.substr(0, s.length - 2));
    // subtract the padding twice
    return Math.round(td.offsetWidth - 2 * p);
  }

  // otherwise, fall back to the old way of calculating
  var container = element.closest('div'); // This is the panel, not the cell that contains the IMG
  if (container !== undefined) {
    return Math.round(container.width() * RELATIVE_SIZE);
  }
  return NaN;
};
var recalculateBox = debounce(function () {
  var e = $('#availability-box');
  // Update the timeline headers
  var imgs = (0, _find.default)(e).call(e, 'img');
  for (var i = 0; i < imgs.length; i++) {
    var img = $(imgs[i]);
    var w = getSize(img);
    if (w) {
      var imgsrc = img.data('imgsrc') + w;
      img.attr('src', imgsrc);
    }
  }
  // Update the timeline html/images
  var spans = (0, _find.default)(e).call(e, 'span');
  for (var _i = 0; _i < spans.length; _i++) {
    var span = $(spans[_i]);
    var _w = getSize(span);
    if (_w && span.data('src')) {
      var htmlsrc = span.data('src') + _w;
      span.load(String(htmlsrc));
    }
  }
}, DEBOUNCE_RATE);
$(document).ready(recalculateBox);
window.addEventListener('resize', recalculateBox);

/***/ })

},[["./src/main/assets/js/apps/timeline-resize/index.js","vendor"]]]);
});
//# sourceMappingURL=timeline-resize.js.map