var _imports_0 = "data:image/png;base64,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";
var App_vue_vue_type_style_index_0_scoped_true_lang = /* @__PURE__ */ (() => "#app[data-v-a62ce854]{font-family:Avenir,Helvetica,Arial,sans-serif;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;text-align:center;color:#2c3e50;margin-top:60px}\n")();
var _export_sfc = (sfc, props) => {
  const target = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target[key] = val;
  }
  return target;
};
const _sfc_main$1 = {};
const _createElementVNode$1 = window["Vue"].createElementVNode;
const _resolveComponent = window["Vue"].resolveComponent;
const _createVNode = window["Vue"].createVNode;
const _Fragment$1 = window["Vue"].Fragment;
const _openBlock$1 = window["Vue"].openBlock;
const _createElementBlock$1 = window["Vue"].createElementBlock;
const _pushScopeId$1 = window["Vue"].pushScopeId;
const _popScopeId$1 = window["Vue"].popScopeId;
const _withScopeId$1 = (n) => (_pushScopeId$1("data-v-a62ce854"), n = n(), _popScopeId$1(), n);
const _hoisted_1$1 = /* @__PURE__ */ _withScopeId$1(() => /* @__PURE__ */ _createElementVNode$1("img", {
  alt: "Vue logo",
  src: _imports_0
}, null, -1));
function _sfc_render(_ctx, _cache) {
  const _component_router_view = _resolveComponent("router-view");
  return _openBlock$1(), _createElementBlock$1(_Fragment$1, null, [
    _hoisted_1$1,
    _createVNode(_component_router_view)
  ], 64);
}
var App = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["render", _sfc_render], ["__scopeId", "data-v-a62ce854"]]);
var HelloWorld_vue_vue_type_style_index_0_scoped_true_lang = /* @__PURE__ */ (() => "a[data-v-5ac905a0]{color:#42b983}code[data-v-5ac905a0]{background-color:#eee;padding:2px 4px;border-radius:4px;color:#304455}table[data-v-5ac905a0],th[data-v-5ac905a0],td[data-v-5ac905a0]{border:2px solid black;border-collapse:collapse}th[data-v-5ac905a0]{background-color:#228b22}\n")();
const _defineComponent = window["Vue"].defineComponent;
const _createElementVNode = window["Vue"].createElementVNode;
const _createTextVNode = window["Vue"].createTextVNode;
const _toDisplayString = window["Vue"].toDisplayString;
const _Fragment = window["Vue"].Fragment;
const _openBlock = window["Vue"].openBlock;
const _createElementBlock = window["Vue"].createElementBlock;
const _pushScopeId = window["Vue"].pushScopeId;
const _popScopeId = window["Vue"].popScopeId;
const _withScopeId = (n) => (_pushScopeId("data-v-5ac905a0"), n = n(), _popScopeId(), n);
const _hoisted_1 = /* @__PURE__ */ _withScopeId(() => /* @__PURE__ */ _createElementVNode("h1", null, "This is an example UI Extension component plugin installed at runtime as a Karaf feature", -1));
const _hoisted_2 = /* @__PURE__ */ _withScopeId(() => /* @__PURE__ */ _createElementVNode("p", null, [
  /* @__PURE__ */ _createTextVNode(" For more information: "),
  /* @__PURE__ */ _createElementVNode("a", {
    href: "https://github.com/OpenNMS/opennms-integration-api",
    target: "_blank"
  }, "OpenNMS Integration API")
], -1));
const _hoisted_3 = /* @__PURE__ */ _withScopeId(() => /* @__PURE__ */ _createElementVNode("table", { style: { "width": "60%" } }, [
  /* @__PURE__ */ _createElementVNode("tr", null, [
    /* @__PURE__ */ _createElementVNode("th", { style: { "width": "20%" } }, "Product"),
    /* @__PURE__ */ _createElementVNode("th", { style: { "width": "40%" } }, "Description")
  ]),
  /* @__PURE__ */ _createElementVNode("tr", null, [
    /* @__PURE__ */ _createElementVNode("td", null, "Horizon"),
    /* @__PURE__ */ _createElementVNode("td", null, "Our free community-driven project includes the latest technology and features delivered through a rapid release cycle.")
  ]),
  /* @__PURE__ */ _createElementVNode("tr", null, [
    /* @__PURE__ */ _createElementVNode("td", null, "Meridian"),
    /* @__PURE__ */ _createElementVNode("td", null, "Meridian is a subscription-based, optimized and stable version of the OpenNMS platform.")
  ])
], -1));
const ref = window["Vue"].ref;
const _sfc_main = /* @__PURE__ */ _defineComponent({
  __name: "HelloWorld",
  setup(__props) {
    const count = ref(0);
    return (_ctx, _cache) => {
      return _openBlock(), _createElementBlock(_Fragment, null, [
        _hoisted_1,
        _hoisted_2,
        _createElementVNode("button", {
          type: "button",
          onClick: _cache[0] || (_cache[0] = ($event) => count.value++)
        }, "count is: " + _toDisplayString(count.value), 1),
        _hoisted_3
      ], 64);
    };
  }
});
var HelloWorld = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-5ac905a0"]]);
const createRouter = window["VueRouter"].createRouter;
const createWebHistory = window["VueRouter"].createWebHistory;
const routes = [
  {
    path: "/",
    name: "hello",
    component: HelloWorld
  }
];
const VRouter = window.VRouter;
if (VRouter) {
  for (const route of routes) {
    const { path, name, component } = route;
    VRouter.addRoute("Plugin", { path: path.slice(1), name, component });
  }
}
createRouter({
  history: createWebHistory(),
  routes
});
window["Vue"].createApp;
window["Pinia"].createPinia;
window["uiextension"] = App;
