/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
package org.opennms.features.topology.app.internal.menu;

import java.util.List;

import org.opennms.features.topology.api.CheckedOperation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.topo.VertexRef;

import com.google.common.collect.Lists;

/**
 *
 */
public class OperationMenuItem implements MenuItem {

    private final OperationServiceWrapper operationServiceWrapper;

    private int order = -1;

    public OperationMenuItem(OperationServiceWrapper operationServiceWrapper) {
        this.operationServiceWrapper = operationServiceWrapper;
    }

    @Override
    public String getLabel() {
        return operationServiceWrapper.getCaption();
    }

    @Override
    public boolean isVisible(List<VertexRef> targets, OperationContext operationContext) {
        return operationServiceWrapper.getOperation().display(targets, operationContext);
    }

    @Override
    public boolean isEnabled(List<VertexRef> targets, OperationContext operationContext) {
        return operationServiceWrapper.getOperation().enabled(targets, operationContext);
    }

    @Override
    public List<MenuItem> getChildren() {
        return Lists.newArrayList();
    }

    @Override
    public void addChildren(MenuItem menuItem) {
		throw new UnsupportedOperationException();
    }

    @Override
    public MenuCommand getCommand() {
        return (targets, operationContext) -> operationServiceWrapper.getOperation().execute(targets, operationContext);
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return order;
    }

    @Override
    public boolean isCheckable() {
        return operationServiceWrapper.getOperation() instanceof CheckedOperation;
    }

    @Override
    public boolean isChecked(List<VertexRef> targets, OperationContext operationContext) {
        return isCheckable() && ((CheckedOperation) operationServiceWrapper.getOperation()).isChecked(targets, operationContext);
    }
}
