/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.net.ConnectException;
import java.util.Date;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.access.event.AuthorizationFailureEvent;
import org.springframework.security.access.event.AuthorizedEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.util.Assert;
import org.springframework.web.context.support.ServletRequestHandledEvent;

public class SecurityAuthenticationEventOnmsEventBuilder
implements ApplicationListener<ApplicationEvent>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityAuthenticationEventOnmsEventBuilder.class);
    public static final String SUCCESS_UEI = "uei.opennms.org/internal/authentication/successfulLogin";
    public static final String FAILURE_UEI = "uei.opennms.org/internal/authentication/failure";
    private EventProxy m_eventProxy;

    public void onApplicationEvent(ApplicationEvent event) {
        EventBuilder builder;
        AuthenticationSuccessEvent authEvent;
        LOG.debug("Received ApplicationEvent {}", event.getClass());
        if (event instanceof AuthenticationSuccessEvent) {
            authEvent = (AuthenticationSuccessEvent)event;
            builder = this.createEvent(SUCCESS_UEI, (AbstractAuthenticationEvent)authEvent);
            builder.setTime(new Date(event.getTimestamp()));
            if (!"true".equalsIgnoreCase(System.getProperty("org.opennms.security.disableLoginSuccessEvent"))) {
                this.sendEvent(builder.getEvent());
            }
        }
        if (event instanceof AbstractAuthenticationFailureEvent) {
            authEvent = (AbstractAuthenticationFailureEvent)event;
            LOG.debug("AbstractAuthenticationFailureEvent was received, exception message - {}", (Object)authEvent.getException().getMessage());
            builder = this.createEvent(FAILURE_UEI, (AbstractAuthenticationEvent)authEvent);
            builder.setTime(new Date(event.getTimestamp()));
            builder.addParam("exceptionName", ((Object)((Object)authEvent.getException())).getClass().getSimpleName());
            builder.addParam("exceptionMessage", authEvent.getException().getMessage());
            this.sendEvent(builder.getEvent());
        }
        if (event instanceof AuthorizedEvent) {
            authEvent = (AuthorizedEvent)event;
            LOG.debug("AuthorizedEvent received - \n  Details - {}\n  Principal - {}", authEvent.getAuthentication().getDetails(), authEvent.getAuthentication().getPrincipal());
        }
        if (event instanceof AuthorizationFailureEvent) {
            authEvent = (AuthorizationFailureEvent)event;
            LOG.debug("AuthorizationFailureEvent received  -\n   Details - {}\n  Principal - {}", authEvent.getAuthentication().getDetails(), authEvent.getAuthentication().getPrincipal());
        }
        if (event instanceof InteractiveAuthenticationSuccessEvent) {
            authEvent = (InteractiveAuthenticationSuccessEvent)event;
            LOG.debug("InteractiveAuthenticationSuccessEvent received - \n  Details - {}\n  Principal - {}", authEvent.getAuthentication().getDetails(), authEvent.getAuthentication().getPrincipal());
        }
        if (event instanceof ServletRequestHandledEvent) {
            authEvent = (ServletRequestHandledEvent)event;
            LOG.debug("ServletRequestHandledEvent received - {}\n  Servlet - {}\n  URL - {}", new Object[]{authEvent.getDescription(), authEvent.getServletName(), authEvent.getRequestUrl()});
            LOG.info("{} requested from {} by user {}", new Object[]{authEvent.getRequestUrl(), authEvent.getClientAddress(), authEvent.getUserName()});
        }
    }

    private EventBuilder createEvent(String uei, AbstractAuthenticationEvent authEvent) {
        WebAuthenticationDetails webDetails;
        EventBuilder builder = new EventBuilder(uei, "OpenNMS.WebUI");
        builder.setTime(new Date(authEvent.getTimestamp()));
        Authentication auth = authEvent.getAuthentication();
        if (auth != null && auth.getName() != null) {
            builder.addParam("user", WebSecurityUtils.sanitizeString((String)auth.getName()));
        }
        if (auth != null && auth.getDetails() != null && auth.getDetails() instanceof WebAuthenticationDetails && (webDetails = (WebAuthenticationDetails)auth.getDetails()).getRemoteAddress() != null) {
            builder.addParam("ip", webDetails.getRemoteAddress());
        }
        return builder;
    }

    private void sendEvent(Event onmsEvent) {
        try {
            this.m_eventProxy.send(onmsEvent);
        }
        catch (EventProxyException e) {
            if (ExceptionUtils.getRootCause((Throwable)e) instanceof ConnectException) {
                LOG.error("Failed to send OpenNMS event to event proxy ( {} )", (Object)this.m_eventProxy, (Object)e);
            }
            LOG.error("Failed to send OpenNMS event to event proxy ( {} )", (Object)this.m_eventProxy, (Object)e);
        }
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_eventProxy, (String)"property eventProxy must be set");
    }
}

