/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import org.opennms.web.springframework.security.SpringSecurityUser;
import org.opennms.web.springframework.security.SpringSecurityUserDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class OpenNMSUserDetailsService
implements UserDetailsService,
InitializingBean {
    private SpringSecurityUserDao m_userDao;
    private boolean m_trimRealm = false;

    public OpenNMSUserDetailsService() {
    }

    public OpenNMSUserDetailsService(SpringSecurityUserDao userDao) {
        this.m_userDao = userDao;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_userDao);
    }

    public UserDetails loadUserByUsername(String rawUsername) throws UsernameNotFoundException, DataAccessException {
        String username = this.m_trimRealm && rawUsername.contains("@") ? rawUsername.substring(0, rawUsername.indexOf("@")) : rawUsername;
        SpringSecurityUser userDetails = this.m_userDao.getByUsername(username);
        if (userDetails == null) {
            throw new UsernameNotFoundException("Unable to locate " + username + " in the userDao");
        }
        return userDetails;
    }

    public void setUserDao(SpringSecurityUserDao userDao) {
        this.m_userDao = userDao;
    }

    public SpringSecurityUserDao getUserDao() {
        return this.m_userDao;
    }

    public void setTrimRealm(boolean trimRealm) {
        this.m_trimRealm = trimRealm;
    }

    public boolean getTrimRealm() {
        return this.m_trimRealm;
    }
}

