/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiskUsageMonitor
extends SnmpMonitorStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(DiskUsageMonitor.class);
    private static final String m_serviceName = "DISK-USAGE";
    private static final String hrStorageDescr = ".1.3.6.1.2.1.25.2.3.1.3";
    private static final String hrStorageSize = ".1.3.6.1.2.1.25.2.3.1.5";
    private static final String hrStorageUsed = ".1.3.6.1.2.1.25.2.3.1.6";

    public String serviceName() {
        return m_serviceName;
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        MatchType matchType = MatchType.EXACT;
        RequireType reqType = RequireType.ALL;
        PollStatus status = PollStatus.available();
        InetAddress ipaddr = svc.getAddress();
        SnmpAgentConfig agentConfig = this.getAgentConfig(svc, parameters);
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)hostAddress);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        String diskNamePattern = ParameterMap.getKeyedString(parameters, (String)"disk", null);
        if (diskNamePattern == null) {
            throw new RuntimeException("Invalid null value for parameter 'disk'");
        }
        Integer percentFree = ParameterMap.getKeyedInteger(parameters, (String)"free", (int)15);
        String matchTypeStr = ParameterMap.getKeyedString(parameters, (String)"match-type", (String)"exact");
        try {
            matchType = MatchType.valueOf(matchTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unknown value '" + matchTypeStr + "' for parameter 'match-type'");
        }
        String reqTypeStr = ParameterMap.getKeyedString(parameters, (String)"require-type", (String)"all");
        try {
            reqType = RequireType.valueOf(reqTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unknown value '" + reqTypeStr + "' for parameter 'require-type'");
        }
        LOG.debug("poll: diskNamePattern={}", (Object)diskNamePattern);
        LOG.debug("poll: percentfree={}", (Object)percentFree);
        LOG.debug("poll: matchType={}", (Object)matchTypeStr);
        LOG.debug("poll: reqType={}", (Object)reqTypeStr);
        LOG.debug("poll: service={} address={}", (Object)svc, (Object)agentConfig);
        try {
            LOG.debug("poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            SnmpObjId hrStorageDescrSnmpObject = SnmpObjId.get((String)hrStorageDescr);
            Map results = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"DiskUsagePoller", (SnmpObjId)hrStorageDescrSnmpObject);
            if (results.isEmpty()) {
                LOG.debug("SNMP poll failed: no results, addr={} oid={}", (Object)hostAddress, (Object)hrStorageDescrSnmpObject);
                return PollStatus.unavailable((String)"No entries found in hrStorageDescr");
            }
            boolean foundDisk = false;
            for (Map.Entry e : results.entrySet()) {
                LOG.debug("poll: SNMPwalk poll succeeded, addr={} oid={} instance={} value={}", new Object[]{hostAddress, hrStorageDescrSnmpObject, e.getKey(), e.getValue()});
                String snmpInstance = ((SnmpInstId)e.getKey()).toString();
                String diskName = ((SnmpValue)e.getValue()).toString();
                if (!this.isMatch(diskName, diskNamePattern, matchType)) continue;
                LOG.debug("poll: found disk={}", (Object)diskName);
                SnmpObjId hrStorageSizeSnmpObject = SnmpObjId.get((String)hrStorageSize, (String)snmpInstance);
                SnmpObjId hrStorageUsedSnmpObject = SnmpObjId.get((String)hrStorageUsed, (String)snmpInstance);
                SnmpValue snmpSize = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)hrStorageSizeSnmpObject);
                SnmpValue snmpUsed = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)hrStorageUsedSnmpObject);
                float calculatedPercentage = ((float)snmpSize.toLong() - (float)snmpUsed.toLong()) / (float)snmpSize.toLong() * 100.0f;
                LOG.debug("poll: calculatedPercentage={} percentFree={}", (Object)Float.valueOf(calculatedPercentage), (Object)percentFree);
                if (calculatedPercentage < (float)percentFree.intValue()) {
                    return PollStatus.unavailable((String)(diskName + " usage high (" + (100 - (int)calculatedPercentage) + "%)"));
                }
                if (matchType == MatchType.EXACT || reqType == RequireType.ANY) {
                    return status;
                }
                if (reqType != RequireType.ALL) continue;
                foundDisk = true;
            }
            if (foundDisk) {
                return status;
            }
            LOG.debug("poll: no disks found");
            return PollStatus.unavailable((String)("Could not find " + diskNamePattern + " in hrStorageTable"));
        }
        catch (NumberFormatException e) {
            String reason = "Number operator used on a non-number " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable((String)reason);
        }
        catch (IllegalArgumentException e) {
            String reason = "Invalid SNMP Criteria: " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable((String)reason);
        }
        catch (Throwable t) {
            String reason = "Unexpected exception during SNMP poll of interface " + hostAddress;
            LOG.debug(reason, t);
            status = PollStatus.unavailable((String)reason);
        }
        return status;
    }

    private boolean isMatch(String candidate, String target, MatchType matchType) {
        boolean matches = false;
        LOG.debug("isMatch: candidate is '{}', matching against target '{}'", (Object)candidate, (Object)target);
        if (matchType == MatchType.EXACT) {
            LOG.debug("isMatch: Attempting equality match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = candidate.equals(target);
        } else if (matchType == MatchType.STARTSWITH) {
            LOG.debug("isMatch: Attempting startsWith match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = candidate.startsWith(target);
        } else if (matchType == MatchType.ENDSWITH) {
            LOG.debug("isMatch: Attempting endsWith match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = candidate.endsWith(target);
        } else if (matchType == MatchType.REGEX) {
            LOG.debug("isMatch: Attempting regex match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = Pattern.compile(target).matcher(candidate).find();
        }
        LOG.debug("isMatch: Match is {}", (Object)(matches ? "positive" : "negative"));
        return matches;
    }

    private static enum MatchType {
        EXACT,
        STARTSWITH,
        ENDSWITH,
        REGEX;

    }

    private static enum RequireType {
        NONE,
        ANY,
        ALL;

    }
}

