/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability;

import io.swagger.v3.oas.annotations.Hidden;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.reporting.availability.Day;

@XmlRootElement(name="week")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Week
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="day", required=true)
    private List<Day> dayList = new ArrayList<Day>();

    public void addDay(Day vDay) throws IndexOutOfBoundsException {
        if (this.dayList.size() >= 7) {
            throw new IndexOutOfBoundsException("addDay has a maximum of 7");
        }
        this.dayList.add(vDay);
    }

    public void addDay(int index, Day vDay) throws IndexOutOfBoundsException {
        if (this.dayList.size() >= 7) {
            throw new IndexOutOfBoundsException("addDay has a maximum of 7");
        }
        this.dayList.add(index, vDay);
    }

    public Enumeration<Day> enumerateDay() {
        return Collections.enumeration(this.dayList);
    }

    public Day getDay(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.dayList.size()) {
            throw new IndexOutOfBoundsException("getDay: Index value '" + index + "' not in range [0.." + (this.dayList.size() - 1) + "]");
        }
        return this.dayList.get(index);
    }

    public Day[] getDay() {
        Day[] array = new Day[]{};
        return this.dayList.toArray(array);
    }

    public List<Day> getDayCollection() {
        return this.dayList;
    }

    public int getDayCount() {
        return this.dayList.size();
    }

    public Iterator<Day> iterateDay() {
        return this.dayList.iterator();
    }

    public void removeAllDay() {
        this.dayList.clear();
    }

    public boolean removeDay(Day vDay) {
        boolean removed = this.dayList.remove(vDay);
        return removed;
    }

    public Day removeDayAt(int index) {
        Day obj = this.dayList.remove(index);
        return obj;
    }

    @Hidden
    public void setDay(int index, Day vDay) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.dayList.size()) {
            throw new IndexOutOfBoundsException("setDay: Index value '" + index + "' not in range [0.." + (this.dayList.size() - 1) + "]");
        }
        this.dayList.set(index, vDay);
    }

    @Hidden
    public void setDay(Day[] vDayArray) {
        this.dayList.clear();
        for (int i = 0; i < vDayArray.length; ++i) {
            this.dayList.add(vDayArray[i]);
        }
    }

    public void setDay(List<Day> vDayList) {
        this.dayList.clear();
        this.dayList.addAll(vDayList);
    }

    @Hidden
    public void setDayCollection(List<Day> dayList) {
        this.dayList = dayList;
    }
}

