/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.daemon;

import org.opennms.core.logging.Logging;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.netmgt.model.ServiceDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceDaemon
implements ServiceDaemon,
SpringServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServiceDaemon.class);
    private volatile int m_status;
    private final String m_name;
    private final Object m_statusLock = new Object();

    public final void afterPropertiesSet() throws Exception {
        this.init();
    }

    protected abstract void onInit();

    protected void onPause() {
    }

    protected void onResume() {
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    public final String getName() {
        return this.m_name;
    }

    protected AbstractServiceDaemon(String name) {
        this.m_name = name;
        this.setStatus(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setStatus(int status) {
        Object object = this.m_statusLock;
        synchronized (object) {
            this.m_status = status;
            this.m_statusLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void waitForStatus(int status, long timeout) throws InterruptedException {
        Object object = this.m_statusLock;
        synchronized (object) {
            long now;
            long last = System.currentTimeMillis();
            for (long waitTime = timeout; status != this.m_status && waitTime > 0L; waitTime -= now - last) {
                this.m_statusLock.wait(waitTime);
                now = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void waitForStatus(int status) throws InterruptedException {
        Object object = this.m_statusLock;
        synchronized (object) {
            while (status != this.m_status) {
                this.m_statusLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        Object object = this.m_statusLock;
        synchronized (object) {
            return this.m_status;
        }
    }

    public String getStatusText() {
        return STATUS_NAMES[this.getStatus()];
    }

    public String status() {
        return this.getStatusText();
    }

    protected synchronized boolean isRunning() {
        return this.getStatus() == 2;
    }

    protected synchronized boolean isPaused() {
        return this.getStatus() == 6;
    }

    protected synchronized boolean isStarting() {
        return this.getStatus() == 1;
    }

    public final void init() {
        Logging.withPrefix((String)this.getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.info("{} initializing.", (Object)AbstractServiceDaemon.this.getName());
                AbstractServiceDaemon.this.onInit();
                LOG.info("{} initialization complete.", (Object)AbstractServiceDaemon.this.getName());
            }
        });
    }

    public final void pause() {
        Logging.withPrefix((String)this.getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!AbstractServiceDaemon.this.isRunning()) {
                    return;
                }
                LOG.info("{} pausing.", (Object)AbstractServiceDaemon.this.getName());
                AbstractServiceDaemon.this.setStatus(5);
                AbstractServiceDaemon.this.onPause();
                AbstractServiceDaemon.this.setStatus(6);
                LOG.info("{} paused.", (Object)AbstractServiceDaemon.this.getName());
            }
        });
    }

    public final void resume() {
        Logging.withPrefix((String)this.getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!AbstractServiceDaemon.this.isPaused()) {
                    return;
                }
                LOG.info("{} resuming.", (Object)AbstractServiceDaemon.this.getName());
                AbstractServiceDaemon.this.setStatus(7);
                AbstractServiceDaemon.this.onResume();
                AbstractServiceDaemon.this.setStatus(2);
                LOG.info("{} resumed.", (Object)AbstractServiceDaemon.this.getName());
            }
        });
    }

    @Override
    public final synchronized void start() {
        Logging.withPrefix((String)this.getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.info("{} starting.", (Object)AbstractServiceDaemon.this.getName());
                AbstractServiceDaemon.this.setStatus(1);
                AbstractServiceDaemon.this.onStart();
                AbstractServiceDaemon.this.setStatus(2);
                LOG.info("{} started.", (Object)AbstractServiceDaemon.this.getName());
            }
        });
    }

    public final synchronized void stop() {
        Logging.withPrefix((String)this.getName(), (Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.info("{} stopping.", (Object)AbstractServiceDaemon.this.getName());
                AbstractServiceDaemon.this.setStatus(3);
                AbstractServiceDaemon.this.onStop();
                AbstractServiceDaemon.this.setStatus(4);
                LOG.info("{} stopped.", (Object)AbstractServiceDaemon.this.getName());
            }
        });
    }

    public final void destroy() {
        this.stop();
    }
}

