/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.domain;

import java.util.Objects;
import org.opennms.netmgt.graph.api.Edge;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.domain.AbstractDomainElementBuilder;
import org.opennms.netmgt.graph.domain.simple.SimpleDomainEdge;

public abstract class AbstractDomainEdge
implements Edge {
    protected final GenericEdge delegate;

    public AbstractDomainEdge(GenericEdge genericEdge) {
        this.delegate = genericEdge;
    }

    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    public String getId() {
        return this.delegate.getId();
    }

    public VertexRef getSource() {
        return this.delegate.getSource();
    }

    public VertexRef getTarget() {
        return this.delegate.getTarget();
    }

    public GenericEdge asGenericEdge() {
        return this.delegate;
    }

    public String getLabel() {
        return this.delegate.getLabel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDomainEdge that = (SimpleDomainEdge)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    public static class AbstractDomainEdgeBuilder<T extends AbstractDomainElementBuilder<?>>
    extends AbstractDomainElementBuilder<T> {
        protected VertexRef source;
        protected VertexRef target;

        protected AbstractDomainEdgeBuilder() {
        }

        public T source(VertexRef source) {
            this.source = source;
            return (T)this;
        }

        public T source(String namespace, String vertexId) {
            return this.source(new VertexRef(namespace, vertexId));
        }

        public T target(VertexRef target) {
            this.target = target;
            return (T)this;
        }

        public T target(String namespace, String vertexId) {
            return this.target(new VertexRef(namespace, vertexId));
        }

        @Override
        public T id(String id) {
            this.properties.put("id", id);
            return (T)this;
        }
    }
}

