/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.catstatus.support;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.viewsdisplay.Section;
import org.opennms.netmgt.config.viewsdisplay.View;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.web.svclayer.catstatus.CategoryStatusService;
import org.opennms.web.svclayer.catstatus.model.StatusCategory;
import org.opennms.web.svclayer.catstatus.model.StatusNode;
import org.opennms.web.svclayer.catstatus.model.StatusSection;
import org.opennms.web.svclayer.catstatus.support.CategoryBuilder;
import org.opennms.web.svclayer.dao.CategoryConfigDao;
import org.opennms.web.svclayer.dao.ViewDisplayDao;

public class DefaultCategoryStatusService
implements CategoryStatusService {
    private ViewDisplayDao m_viewDisplayDao;
    private CategoryConfigDao m_categoryConfigDao;
    private OutageDao m_outageDao;

    @Override
    public Collection<StatusSection> getCategoriesStatus() {
        View view = this.m_viewDisplayDao.getView();
        List<Section> sections = this.getSectionsForView(view);
        ArrayList<StatusSection> statusSections = new ArrayList<StatusSection>();
        for (Section section : sections) {
            statusSections.add(this.createSection(section));
        }
        return statusSections;
    }

    private StatusSection createSection(Section section) {
        StatusSection statusSection = new StatusSection();
        statusSection.setName(section.getSectionName());
        List<String> categories = this.getCategoriesForSection(section);
        for (String category : categories) {
            StatusCategory statusCategory = this.createCategory(category);
            statusSection.addCategory(statusCategory);
        }
        return statusSection;
    }

    private StatusCategory createCategory(String category) {
        CategoryBuilder categoryBuilder = new CategoryBuilder();
        StatusCategory statusCategory = new StatusCategory();
        Category categoryDetail = this.m_categoryConfigDao.getCategoryByLabel(category);
        statusCategory.setLabel(category);
        ServiceSelector selector = new ServiceSelector(categoryDetail.getRule(), this.getServicesForCategory(categoryDetail));
        Collection outages = this.m_outageDao.matchingCurrentOutages(selector);
        for (OnmsOutage outage : outages) {
            OnmsMonitoredService monitoredService = outage.getMonitoredService();
            OnmsServiceType serviceType = monitoredService.getServiceType();
            OnmsIpInterface ipInterface = monitoredService.getIpInterface();
            String ipAddress = InetAddressUtils.str((InetAddress)ipInterface.getIpAddress());
            categoryBuilder.addOutageService(monitoredService.getNodeId(), ipAddress, ipAddress, ipInterface.getNode().getLabel(), serviceType.getName());
        }
        for (StatusNode node : categoryBuilder.getNodes()) {
            statusCategory.addNode(node);
        }
        return statusCategory;
    }

    public void setViewDisplayDao(ViewDisplayDao viewDisplayDao) {
        this.m_viewDisplayDao = viewDisplayDao;
    }

    public void setCategoryConfigDao(CategoryConfigDao categoryDao) {
        this.m_categoryConfigDao = categoryDao;
    }

    public void setOutageDao(OutageDao outageDao) {
        this.m_outageDao = outageDao;
    }

    private List<Section> getSectionsForView(View view) {
        return view.getSections();
    }

    private List<String> getCategoriesForSection(Section section) {
        return section.getCategories();
    }

    private List<String> getServicesForCategory(Category categoryDetail) {
        return categoryDetail.getServices();
    }
}

