/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rss;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntryImpl;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.event.AcknowledgeType;
import org.opennms.web.event.Event;
import org.opennms.web.event.EventFactory;
import org.opennms.web.event.SortStyle;
import org.opennms.web.event.filter.NodeFilter;
import org.opennms.web.event.filter.SeverityFilter;
import org.opennms.web.filter.EqualsFilter;
import org.opennms.web.filter.Filter;
import org.opennms.web.rss.AbstractFeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventFeed
extends AbstractFeed {
    private static final Logger LOG = LoggerFactory.getLogger(EventFeed.class);

    @Override
    public SyndFeed getFeed() {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle("Events");
        feed.setDescription("OpenNMS Events");
        feed.setLink(this.getUrlBase() + "event/list.htm");
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        try {
            Event[] events;
            ArrayList<EqualsFilter> filters = new ArrayList<EqualsFilter>();
            if (this.getRequest().getParameter("node") != null) {
                Integer nodeId = WebSecurityUtils.safeParseInt((String)this.getRequest().getParameter("node"));
                filters.add(new NodeFilter((int)nodeId, this.getServletContext()));
            }
            if (this.getRequest().getParameter("severity") != null) {
                String parameter = this.getRequest().getParameter("severity");
                try {
                    Integer severityId = WebSecurityUtils.safeParseInt((String)parameter);
                    filters.add(new SeverityFilter(severityId));
                }
                catch (NumberFormatException e) {
                    OnmsSeverity[] onmsSeverityArray = OnmsSeverity.values();
                    int n = onmsSeverityArray.length;
                    for (int i = 0; i < n; ++i) {
                        OnmsSeverity sev = onmsSeverityArray[i];
                        if (!sev.getLabel().equalsIgnoreCase(parameter)) continue;
                        filters.add(new SeverityFilter(sev));
                        break;
                    }
                }
            }
            for (Event event : events = EventFactory.getEvents(SortStyle.TIME, AcknowledgeType.BOTH, filters.toArray(new Filter[0]), this.getMaxEntries(), 0)) {
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setPublishedDate(event.getTime());
                if (event.getAcknowledgeTime() != null) {
                    entry.setTitle(this.sanitizeTitle(event.getLogMessage()) + " (Acknowledged by " + event.getAcknowledgeUser() + ")");
                    entry.setUpdatedDate(event.getAcknowledgeTime());
                } else {
                    entry.setTitle(this.sanitizeTitle(event.getLogMessage()));
                    entry.setUpdatedDate(event.getTime());
                }
                entry.setLink(this.getUrlBase() + "event/detail.jsp?id=" + event.getId());
                entry.setAuthor("OpenNMS");
                SyndContentImpl content = new SyndContentImpl();
                content.setType("text/html");
                content.setValue(event.getDescription());
                entry.setDescription((SyndContent)content);
                entries.add(entry);
            }
        }
        catch (SQLException e) {
            LOG.warn("unable to get event(s)", (Throwable)e);
        }
        feed.setEntries(entries);
        return feed;
    }
}

