/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage.filter;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.opennms.web.filter.EqualsFilter;
import org.opennms.web.filter.SQLType;

public class ForeignSourceFilter
extends EqualsFilter<String> {
    public static final String TYPE = "foreignsource";

    public ForeignSourceFilter(String foreignSource) {
        super(TYPE, SQLType.STRING, "OUTAGES.IFSERVICEID", "NODE.foreignSource", foreignSource);
    }

    @Override
    public String getSQLTemplate() {
        return " " + this.getSQLFieldName() + " IN (SELECT DISTINCT ifservices.id FROM ifservices, ipinterface, node WHERE ifservices.ipinterfaceid = ipinterface.id AND ipinterface.nodeid = node.nodeid AND node.foreignSource=%s)";
    }

    @Override
    public Criterion getCriterion() {
        return Restrictions.sqlRestriction((String)" {alias}.ifserviceid IN (SELECT DISTINCT ifservices.id FROM ifservices, ipinterface, node WHERE ifservices.ipinterfaceid = ipinterface.id AND ipinterface.nodeid = node.nodeid AND node.foreignSource=?)", this.getValue(), (Type)StringType.INSTANCE);
    }

    @Override
    public String toString() {
        return "<ForeignSourceFilter: " + this.getDescription() + ">";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForeignSourceFilter)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

