/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.navigate;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.opennms.web.navigate.DisplayStatus;
import org.opennms.web.navigate.MenuContext;

public interface NavBarEntry {
    public String getName();

    public String getDisplayString();

    public String getUrl();

    public String getSystemProperty();

    public String getSystemPropertyValue();

    public List<NavBarEntry> getEntries();

    public boolean hasEntries();

    public DisplayStatus evaluate(MenuContext var1);

    @Deprecated
    default public DisplayStatus evaluate(HttpServletRequest request) {
        String location = request.getParameter("location");
        Function<String, Boolean> userInRoleFunction = s -> request.isUserInRole(s);
        return this.evaluate(new NavBarContext(location, userInRoleFunction));
    }

    public static class NavBarContext
    implements MenuContext {
        private final String location;
        private final Function<String, Boolean> userInRoleFunction;

        public NavBarContext(String location, Function<String, Boolean> userInRoleFunction) {
            this.userInRoleFunction = Objects.requireNonNull(userInRoleFunction);
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean isUserInRole(String role) {
            return this.userInRoleFunction.apply(role);
        }
    }
}

