/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.opennms.web.filter.BaseFilter;
import org.opennms.web.filter.SQLType;

public abstract class MultiArgFilter<T>
extends BaseFilter<T> {
    private T[] m_values;

    public MultiArgFilter(String filterType, SQLType<T> sqlType, String fieldName, String propertyName, T[] values) {
        super(filterType, sqlType, fieldName, propertyName);
        this.m_values = values;
    }

    public T[] getValues() {
        return this.m_values;
    }

    public List<T> getValuesAsList() {
        return Arrays.asList(this.m_values);
    }

    public abstract String getSQLTemplate();

    @Override
    public final int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        for (int i = 0; i < this.m_values.length; ++i) {
            this.bindValue(ps, parameterIndex + i, this.m_values[i]);
        }
        return this.m_values.length;
    }

    @Override
    public final String getValueString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.m_values.length; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this.getValueAsString(this.m_values[i]));
        }
        return buf.toString();
    }

    @Override
    public final String getParamSql() {
        Object[] qmarks = new String[this.m_values.length];
        Arrays.fill(qmarks, "?");
        return String.format(this.getSQLTemplate(), qmarks);
    }

    @Override
    public final String getSql() {
        Object[] formattedVals = new String[this.m_values.length];
        for (int i = 0; i < this.m_values.length; ++i) {
            formattedVals[i] = this.formatValue(this.m_values[i]);
        }
        return String.format(this.getSQLTemplate(), formattedVals);
    }
}

