/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.filter;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.web.filter.OneArgFilter;
import org.opennms.web.filter.SQLType;

public abstract class EqualsFilterNullAware
extends OneArgFilter<String> {
    public EqualsFilterNullAware(String filterType, SQLType<String> type, String fieldName, String propertyName, String value) {
        super(filterType, type, fieldName, propertyName, EqualsFilterNullAware.toValueAllowNull(value));
    }

    private static String toValueAllowNull(String value) {
        return "null".equals(value) ? null : value;
    }

    @Override
    public Criterion getCriterion() {
        if (this.getValue() == null) {
            return Restrictions.isNull((String)this.getPropertyName());
        }
        return Restrictions.eq((String)this.getPropertyName(), this.getValue());
    }

    @Override
    public String getSQLTemplate() {
        if (this.getValue() == null) {
            return " " + this.getSQLFieldName() + " IS NULL ";
        }
        return " " + this.getSQLFieldName() + " =  %s ";
    }
}

