/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event.filter;

import java.util.Collection;
import org.opennms.web.filter.InFilter;
import org.opennms.web.filter.SQLType;

public class EventIdListFilter
extends InFilter<Long> {
    public static final String TYPE = "eventIdList";

    private static Long[] box(long[] values) {
        if (values == null) {
            return null;
        }
        Long[] boxed = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return boxed;
    }

    public EventIdListFilter(long[] eventIds) {
        super(TYPE, SQLType.BIGINT, "EVENTID", "id", EventIdListFilter.box(eventIds));
    }

    public EventIdListFilter(Collection<Long> eventIds) {
        super(TYPE, SQLType.BIGINT, "EVENTID", "id", eventIds.toArray(new Long[0]));
    }

    @Override
    public String getTextDescription() {
        StringBuilder buf = new StringBuilder("eventId in ");
        buf.append("(");
        buf.append(this.getValueString());
        buf.append(")");
        return buf.toString();
    }
}

