/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event;

import java.util.HashMap;
import java.util.Map;
import org.opennms.web.filter.NormalizedAcknowledgeType;
import org.springframework.util.Assert;

public enum AcknowledgeType {
    ACKNOWLEDGED("ack"),
    UNACKNOWLEDGED("unack"),
    BOTH("both");

    private static final Map<String, AcknowledgeType> s_ackTypesString;
    private String m_shortName;

    private AcknowledgeType(String shortName) {
        this.m_shortName = shortName;
    }

    public String toString() {
        return "AcknowledgeType." + this.getName();
    }

    public String getName() {
        return this.name();
    }

    public String getShortName() {
        return this.m_shortName;
    }

    protected String getAcknowledgeTypeClause() {
        switch (this) {
            case ACKNOWLEDGED: {
                return " EVENTACKUSER IS NOT NULL";
            }
            case UNACKNOWLEDGED: {
                return " EVENTACKUSER IS NULL";
            }
            case BOTH: {
                return " (EVENTACKUSER IS NULL OR EVENTACKUSER IS NOT NULL)";
            }
        }
        throw new IllegalArgumentException("Cannot get clause for AcknowledgeType " + this);
    }

    public NormalizedAcknowledgeType toNormalizedAcknowledgeType() {
        return NormalizedAcknowledgeType.createFrom(this);
    }

    public static AcknowledgeType getAcknowledgeType(String ackTypeString) {
        Assert.notNull((Object)ackTypeString, (String)"Cannot take null parameters.");
        return s_ackTypesString.get(ackTypeString.toLowerCase());
    }

    static {
        s_ackTypesString = new HashMap<String, AcknowledgeType>();
        for (AcknowledgeType ackType : AcknowledgeType.values()) {
            s_ackTypesString.put(ackType.getShortName(), ackType);
        }
    }
}

