/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.statisticsReports;

import org.opennms.web.controller.statisticsReports.StatisticsReportIdNotFoundException;
import org.opennms.web.svclayer.StatisticsReportService;
import org.opennms.web.svclayer.model.StatisticsReportCommand;
import org.opennms.web.svclayer.model.StatisticsReportModel;
import org.opennms.web.validator.StatisticsReportCommandValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateObjectRetrievalFailureException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/statisticsReports/report.htm"})
public class ReportController {
    @Autowired
    private StatisticsReportService m_statisticsReportService;
    @Autowired
    private StatisticsReportCommandValidator m_validator;

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView handle(@ModelAttribute(value="command") StatisticsReportCommand command, BindingResult errors) {
        this.m_validator.validate(command, (Errors)errors);
        try {
            StatisticsReportModel report = this.m_statisticsReportService.getReport(command, errors);
            if (report == null) {
                throw new StatisticsReportIdNotFoundException("No such report ID", command.getId().toString(), null);
            }
            return new ModelAndView("statisticsReports/report", "model", (Object)report);
        }
        catch (HibernateObjectRetrievalFailureException horfe) {
            throw new StatisticsReportIdNotFoundException("No such report ID", command.getId().toString(), horfe);
        }
    }
}

