/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.web.controller.ksc.KscReportEditor;
import org.opennms.web.servlet.MissingParameterException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class FormProcMainController
extends AbstractController
implements InitializingBean {
    private KSC_PerformanceReportFactory m_kscReportFactory;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String action = request.getParameter("report_action");
        if (action == null) {
            throw new MissingParameterException("report_action");
        }
        if (Actions.View.toString().equals(action)) {
            ModelAndView modelAndView = new ModelAndView("redirect:/KSC/customView.htm");
            modelAndView.addObject("report", (Object)FormProcMainController.getReportIndex(request));
            modelAndView.addObject("type", (Object)"custom");
            return modelAndView;
        }
        if ((request.isUserInRole("ROLE_ADMIN") || !request.isUserInRole("ROLE_READONLY")) && request.getRemoteUser() != null) {
            KscReportEditor editor = KscReportEditor.getFromSession(request.getSession(), false);
            if (Actions.Customize.toString().equals(action)) {
                editor.loadWorkingReport(this.getKscReportFactory(), FormProcMainController.getReportIndex(request));
                return new ModelAndView("redirect:/KSC/customReport.htm");
            }
            if (Actions.CreateFrom.toString().equals(action)) {
                editor.loadWorkingReportDuplicate(this.getKscReportFactory(), FormProcMainController.getReportIndex(request));
                return new ModelAndView("redirect:/KSC/customReport.htm");
            }
            if (Actions.Delete.toString().equals(action)) {
                this.getKscReportFactory().deleteReportAndSave(FormProcMainController.getReportIndex(request));
                return new ModelAndView("redirect:/KSC/index.jsp");
            }
            if (Actions.Create.toString().equals(action)) {
                editor.loadNewWorkingReport();
                return new ModelAndView("redirect:/KSC/customReport.htm");
            }
        }
        throw new ServletException("Invalid Parameter contents for report_action: " + action);
    }

    private static int getReportIndex(HttpServletRequest request) {
        String report = WebSecurityUtils.sanitizeString((String)request.getParameter("report"));
        if (report == null) {
            throw new MissingParameterException("report");
        }
        return WebSecurityUtils.safeParseInt((String)report);
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"property kscReportFactory must be set");
    }

    public static enum Actions {
        View,
        Customize,
        CreateFrom,
        Delete,
        Create;

    }
}

