/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm.filter;

import javax.servlet.ServletContext;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.filter.EqualsFilter;
import org.opennms.web.filter.SQLType;

public class ServiceFilter
extends EqualsFilter<Integer> {
    public static final String TYPE = "service";
    private ServletContext m_servletContext;

    public ServiceFilter(int serviceId, ServletContext servletContext) {
        super(TYPE, SQLType.INT, "SERVICEID", "serviceType.id", serviceId);
        this.m_servletContext = servletContext;
    }

    @Override
    public String getTextDescription() {
        String serviceName = Integer.toString(this.getServiceId());
        serviceName = NetworkElementFactory.getInstance(this.m_servletContext).getServiceNameFromId(this.getServiceId());
        return "service=" + serviceName;
    }

    @Override
    public String toString() {
        return "<AlarmFactory.ServiceFilter: " + this.getDescription() + ">";
    }

    public int getServiceId() {
        return (Integer)this.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceFilter)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

