/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public enum SortStyle {
    SEVERITY("severity"),
    LASTEVENTTIME("lasteventtime"),
    FIRSTEVENTTIME("firsteventtime"),
    NODE("node"),
    INTERFACE("interface"),
    SERVICE("service"),
    POLLER("poller"),
    ID("id"),
    COUNT("count"),
    ACKUSER("ackuser"),
    LOCATION("location"),
    NODE_LOCATION("nodelocation"),
    SITUATION("situation"),
    REVERSE_SEVERITY("rev_severity"),
    REVERSE_LASTEVENTTIME("rev_lasteventtime"),
    REVERSE_FIRSTEVENTTIME("rev_firsteventtime"),
    REVERSE_NODE("rev_node"),
    REVERSE_INTERFACE("rev_interface"),
    REVERSE_SERVICE("rev_service"),
    REVERSE_POLLER("rev_poller"),
    REVERSE_ID("rev_id"),
    REVERSE_COUNT("rev_count"),
    REVERSE_ACKUSER("rev_ackuser"),
    REVERSE_LOCATION("rev_location"),
    REVERSE_NODE_LOCATION("rev_nodelocation"),
    REVERSE_SITUATION("rev_situation");

    private static final Map<String, SortStyle> m_sortStylesString;
    private String m_shortName;

    private SortStyle(String shortName) {
        this.m_shortName = shortName;
    }

    public String toString() {
        return "SortStyle." + this.getName();
    }

    public String getName() {
        return this.name();
    }

    public String getShortName() {
        return this.m_shortName;
    }

    public static SortStyle getSortStyle(String sortStyleString) {
        Assert.notNull((Object)sortStyleString, (String)"Cannot take null parameters.");
        return m_sortStylesString.get(sortStyleString.toLowerCase());
    }

    protected String getOrderByClause() {
        String clause = null;
        switch (this) {
            case SEVERITY: {
                clause = " ORDER BY SEVERITY DESC";
                break;
            }
            case REVERSE_SEVERITY: {
                clause = " ORDER BY SEVERITY ASC";
                break;
            }
            case LASTEVENTTIME: {
                clause = " ORDER BY LASTEVENTTIME DESC";
                break;
            }
            case REVERSE_LASTEVENTTIME: {
                clause = " ORDER BY LASTEVENTTIME ASC";
                break;
            }
            case FIRSTEVENTTIME: {
                clause = " ORDER BY FIRSTEVENTTIME DESC";
                break;
            }
            case REVERSE_FIRSTEVENTTIME: {
                clause = " ORDER BY FIRSTEVENTTIME ASC";
                break;
            }
            case NODE: {
                clause = " ORDER BY NODELABEL ASC";
                break;
            }
            case REVERSE_NODE: {
                clause = " ORDER BY NODELABEL DESC";
                break;
            }
            case INTERFACE: {
                clause = " ORDER BY IPADDR ASC";
                break;
            }
            case REVERSE_INTERFACE: {
                clause = " ORDER BY IPADDR DESC";
                break;
            }
            case SERVICE: {
                clause = " ORDER BY SERVICENAME ASC";
                break;
            }
            case REVERSE_SERVICE: {
                clause = " ORDER BY SERVICENAME DESC";
                break;
            }
            case POLLER: {
                clause = " ORDER BY EVENTDPNAME ASC";
                break;
            }
            case REVERSE_POLLER: {
                clause = " ORDER BY EVENTDPNAME DESC";
                break;
            }
            case ID: {
                clause = " ORDER BY ALARMID DESC";
                break;
            }
            case REVERSE_ID: {
                clause = " ORDER BY ALARMID ASC";
                break;
            }
            case COUNT: {
                clause = " ORDER BY COUNTER DESC";
                break;
            }
            case REVERSE_COUNT: {
                clause = " ORDER BY COUNTER ASC";
                break;
            }
            case ACKUSER: {
                clause = " ORDER BY ALARMACKUSER ASC";
                break;
            }
            case REVERSE_ACKUSER: {
                clause = " ORDER BY ALARMACKUSER DESC";
                break;
            }
            case LOCATION: {
                clause = " ORDER BY LOCATION ASC";
                break;
            }
            case REVERSE_LOCATION: {
                clause = " ORDER BY LOCATION DESC";
                break;
            }
            case NODE_LOCATION: {
                clause = " ORDER BY NODE.LOCATION ASC, NODE.NODELABEL ASC";
                break;
            }
            case REVERSE_NODE_LOCATION: {
                clause = " ORDER BY NODE.LOCATION DESC, NODE.NODELABEL ASC";
                break;
            }
            case SITUATION: {
                clause = " ORDER BY (SELECT COUNT(*)>0 FROM ALARM_SITUATIONS WHERE ALARM_SITUATIONS.SITUATION_ID = ALARMID) ASC";
                break;
            }
            case REVERSE_SITUATION: {
                clause = " ORDER BY (SELECT COUNT(*)>0 FROM ALARM_SITUATIONS WHERE ALARM_SITUATIONS.SITUATION_ID = ALARMID) DESC";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SortStyle: " + this);
            }
        }
        return clause;
    }

    static {
        m_sortStylesString = new HashMap<String, SortStyle>();
        for (SortStyle sortStyle : SortStyle.values()) {
            m_sortStylesString.put(sortStyle.getShortName(), sortStyle);
        }
    }
}

