/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.api.Util;
import org.opennms.web.svclayer.model.SnmpInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpConfigServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpConfigServlet.class);
    private static final long serialVersionUID = -2298118339644843598L;
    private static final String ACTION_PARAMETER_NAME = "action";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    private void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SnmpInfo snmpInfo = this.createFromRequest(request);
        String firstIPAddress = request.getParameter("firstIPAddress");
        String lastIPAddress = request.getParameter("lastIPAddress");
        String ipAddress = request.getParameter("ipAddress");
        String location = request.getParameter("location");
        LOG.debug("doPost: snmpInfo:{}, firstIpAddress:{}, lastIpAddress:{}", new Object[]{snmpInfo.toString(), firstIPAddress, lastIPAddress});
        SnmpConfigServletAction action = this.determineAction(request);
        boolean sendEvent = this.parseCheckboxValue(request.getParameter("sendEventOption"));
        boolean saveLocally = this.parseCheckboxValue(request.getParameter("saveLocallyOption"));
        switch (action) {
            case GetConfigForIp: {
                request.setAttribute("snmpConfigForIp", (Object)new SnmpInfo(SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)ipAddress), location, false)));
                request.setAttribute("firstIPAddress", (Object)ipAddress);
                request.setAttribute("location", (Object)location);
                break;
            }
            case Save: {
                boolean success = false;
                SnmpEventInfo eventInfo = snmpInfo.createEventInfo(firstIPAddress, lastIPAddress);
                if (saveLocally) {
                    SnmpPeerFactory.getInstance().define(eventInfo);
                    SnmpPeerFactory.getInstance().saveCurrent();
                    success |= true;
                }
                if (sendEvent) {
                    success |= this.sendEvent(eventInfo.createEvent("web ui"));
                }
                if (!success) break;
                request.setAttribute("success", (Object)"success");
                break;
            }
        }
        request.setAttribute("snmpConfig", (Object)Files.toString((File)SnmpPeerFactory.getFile(), (Charset)StandardCharsets.UTF_8));
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/snmpConfig.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private boolean parseCheckboxValue(String parameter) {
        if (Strings.isNullOrEmpty((String)parameter)) {
            return false;
        }
        return "on".equalsIgnoreCase(parameter) || "true".equalsIgnoreCase(parameter) || "checked".equalsIgnoreCase(parameter);
    }

    private boolean sendEvent(Event eventToSend) throws ServletException {
        if (eventToSend == null) {
            return false;
        }
        try {
            EventProxy eventProxy = Util.createEventProxy();
            if (eventProxy == null) {
                throw new ServletException("Event proxy object is null, unable to send event " + eventToSend.getUei());
            }
            eventProxy.send(eventToSend);
            return true;
        }
        catch (Throwable e) {
            throw new ServletException("Could not send event " + eventToSend.getUei(), e);
        }
    }

    private SnmpInfo createFromRequest(HttpServletRequest request) {
        SnmpInfo snmpInfo = new SnmpInfo();
        String version = request.getParameter("version");
        String timeout = request.getParameter("timeout");
        String retryCount = request.getParameter("retryCount");
        String port = request.getParameter("port");
        String maxRequestSize = request.getParameter("maxRequestSize");
        String maxVarsPerPdu = request.getParameter("maxVarsPerPdu");
        String maxRepetitions = request.getParameter("maxRepetitions");
        String proxyHost = request.getParameter("proxyHost");
        String location = request.getParameter("location");
        String ttl = request.getParameter("ttl");
        String readCommunityString = request.getParameter("readCommunityString");
        String writeCommunityString = request.getParameter("writeCommunityString");
        String securityName = request.getParameter("securityName");
        String securityLevel = request.getParameter("securityLevel");
        String authPassPhrase = request.getParameter("authPassPhrase");
        String authProtocol = request.getParameter("authProtocol");
        String privPassPhrase = request.getParameter("privPassPhrase");
        String privProtocol = request.getParameter("privProtocol");
        String engineId = request.getParameter("engineId");
        String contextEngineId = request.getParameter("contextEngineId");
        String contextName = request.getParameter("contextName");
        String enterpriseId = request.getParameter("enterpriseId");
        if (!Strings.isNullOrEmpty((String)authPassPhrase)) {
            snmpInfo.setAuthPassPhrase(authPassPhrase);
        }
        if (!Strings.isNullOrEmpty((String)authProtocol)) {
            snmpInfo.setAuthProtocol(authProtocol);
        }
        if (!Strings.isNullOrEmpty((String)contextEngineId)) {
            snmpInfo.setContextEngineId(contextEngineId);
        }
        if (!Strings.isNullOrEmpty((String)contextName)) {
            snmpInfo.setContextName(contextName);
        }
        if (!Strings.isNullOrEmpty((String)engineId)) {
            snmpInfo.setEngineId(engineId);
        }
        if (!Strings.isNullOrEmpty((String)enterpriseId)) {
            snmpInfo.setEnterpriseId(enterpriseId);
        }
        if (!Strings.isNullOrEmpty((String)maxRepetitions)) {
            snmpInfo.setMaxRepetitions(Integer.valueOf(Integer.parseInt(maxRepetitions)));
        }
        if (!Strings.isNullOrEmpty((String)maxRequestSize)) {
            snmpInfo.setMaxRequestSize(Integer.valueOf(Integer.parseInt(maxRequestSize)));
        }
        if (!Strings.isNullOrEmpty((String)maxVarsPerPdu)) {
            snmpInfo.setMaxVarsPerPdu(Integer.valueOf(Integer.parseInt(maxVarsPerPdu)));
        }
        if (!Strings.isNullOrEmpty((String)port)) {
            snmpInfo.setPort(Integer.valueOf(Integer.parseInt(port)));
        }
        if (!Strings.isNullOrEmpty((String)privPassPhrase)) {
            snmpInfo.setPrivPassPhrase(privPassPhrase);
        }
        if (!Strings.isNullOrEmpty((String)privProtocol)) {
            snmpInfo.setPrivProtocol(privProtocol);
        }
        if (!Strings.isNullOrEmpty((String)proxyHost)) {
            snmpInfo.setProxyHost(proxyHost);
        }
        if (!Strings.isNullOrEmpty((String)readCommunityString)) {
            snmpInfo.setReadCommunity(readCommunityString);
        }
        if (!Strings.isNullOrEmpty((String)retryCount)) {
            snmpInfo.setRetries(Integer.valueOf(Integer.parseInt(retryCount)));
        }
        if (!Strings.isNullOrEmpty((String)securityLevel)) {
            snmpInfo.setSecurityLevel(Integer.valueOf(Integer.parseInt(securityLevel)));
        }
        if (!Strings.isNullOrEmpty((String)securityName)) {
            snmpInfo.setSecurityName(securityName);
        }
        if (!Strings.isNullOrEmpty((String)timeout)) {
            snmpInfo.setTimeout(Integer.valueOf(Integer.parseInt(timeout)));
        }
        if (!Strings.isNullOrEmpty((String)version)) {
            snmpInfo.setVersion(version);
        }
        if (!Strings.isNullOrEmpty((String)writeCommunityString)) {
            snmpInfo.setWriteCommunity(writeCommunityString);
        }
        if (!Strings.isNullOrEmpty((String)location)) {
            snmpInfo.setLocation(location);
        }
        if (!Strings.isNullOrEmpty((String)ttl)) {
            snmpInfo.setTTL(Long.valueOf(Long.parseLong(ttl)));
        }
        return snmpInfo;
    }

    private SnmpConfigServletAction determineAction(HttpServletRequest request) {
        if (request.getParameter(ACTION_PARAMETER_NAME) == null) {
            return SnmpConfigServletAction.Default;
        }
        for (SnmpConfigServletAction eachAction : SnmpConfigServletAction.values()) {
            if (!eachAction.getActionName().equals(request.getParameter(ACTION_PARAMETER_NAME))) continue;
            return eachAction;
        }
        return SnmpConfigServletAction.Default;
    }

    public static enum SnmpConfigServletAction {
        Default("default"),
        GetConfigForIp("get"),
        Save("add");

        private final String actionName;

        private SnmpConfigServletAction(String actionName) {
            this.actionName = actionName;
        }

        public String getActionName() {
            return this.actionName;
        }
    }
}

