/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.groups;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.model.FilterManager;
import org.opennms.web.springframework.security.AclUtils;
import org.opennms.web.springframework.security.OnmsAuthenticationDetails;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class SetUserGroupController
extends AbstractController {
    private FilterManager m_filterManager;
    private GroupDao m_groupDao;

    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        boolean shouldFilter = AclUtils.shouldFilter((Collection)SecurityContextHolder.getContext().getAuthentication().getAuthorities());
        if (httpServletRequest.getMethod().equals("POST") && shouldFilter) {
            String[] split;
            String userGroups = httpServletRequest.getParameter("j_usergroups");
            String[] userGroupList = userGroups != null ? ((split = userGroups.split(","))[0].equals("") ? null : split) : null;
            OnmsAuthenticationDetails details = (OnmsAuthenticationDetails)SecurityContextHolder.getContext().getAuthentication().getDetails();
            details.setUserGroups(userGroupList);
            String user = SecurityContextHolder.getContext().getAuthentication().getName();
            List groups = this.m_groupDao.findGroupsForUser(user);
            String[] groupNames = new String[groups.size()];
            for (int i = 0; i < groups.size(); ++i) {
                groupNames[i] = ((Group)groups.get(i)).getName();
            }
            if (details.getUserGroups() != null && details.getUserGroups().length > 0) {
                HashSet<String> detailsSet = new HashSet<String>(Arrays.asList(details.getUserGroups()));
                HashSet<String> groupSet = new HashSet<String>(Arrays.asList(groupNames));
                if (groupSet.containsAll(detailsSet)) {
                    groupNames = details.getUserGroups();
                }
            }
            this.m_filterManager.enableAuthorizationFilter(groupNames);
        }
        return null;
    }

    public void setFilterManager(FilterManager m_filterManager) {
        this.m_filterManager = m_filterManager;
    }

    public void setGroupDao(GroupDao m_groupDao) {
        this.m_groupDao = m_groupDao;
    }
}

