/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Locale;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class IQ
extends Packet {
    private Type type = Type.GET;

    public IQ() {
    }

    public IQ(IQ iq) {
        super(iq);
        this.type = iq.getType();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type == null ? Type.GET : type;
    }

    @Override
    public CharSequence toXML() {
        XmlStringBuilder buf = new XmlStringBuilder();
        buf.halfOpenElement("iq");
        this.addCommonAttributes(buf);
        if (this.type == null) {
            buf.attribute("type", "get");
        } else {
            buf.attribute("type", this.type.toString());
        }
        buf.rightAngelBracket();
        buf.optAppend(this.getChildElementXML());
        XMPPError error = this.getError();
        if (error != null) {
            buf.append(error.toXML());
        }
        buf.closeElement("iq");
        return buf;
    }

    public abstract CharSequence getChildElementXML();

    public static IQ createResultIQ(IQ request) {
        if (request.getType() != Type.GET && request.getType() != Type.SET) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + request.toXML());
        }
        IQ result = new IQ(){

            @Override
            public String getChildElementXML() {
                return null;
            }
        };
        result.setType(Type.RESULT);
        result.setPacketID(request.getPacketID());
        result.setFrom(request.getTo());
        result.setTo(request.getFrom());
        return result;
    }

    public static IQ createErrorResponse(final IQ request, XMPPError error) {
        if (request.getType() != Type.GET && request.getType() != Type.SET) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + request.toXML());
        }
        IQ result = new IQ(){

            @Override
            public CharSequence getChildElementXML() {
                return request.getChildElementXML();
            }
        };
        result.setType(Type.ERROR);
        result.setPacketID(request.getPacketID());
        result.setFrom(request.getTo());
        result.setTo(request.getFrom());
        result.setError(error);
        return result;
    }

    public static class Type {
        public static final Type GET = new Type("get");
        public static final Type SET = new Type("set");
        public static final Type RESULT = new Type("result");
        public static final Type ERROR = new Type("error");
        private String value;

        public static Type fromString(String type) {
            if (type == null) {
                return null;
            }
            type = type.toLowerCase(Locale.US);
            if (GET.toString().equals(type)) {
                return GET;
            }
            if (SET.toString().equals(type)) {
                return SET;
            }
            if (ERROR.toString().equals(type)) {
                return ERROR;
            }
            if (RESULT.toString().equals(type)) {
                return RESULT;
            }
            return null;
        }

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

