/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.Capability;
import com.vmware.vim25.Event;
import com.vmware.vim25.HostVMotionCompatibility;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ProductComponentInfo;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.UserSession;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.mo.AlarmManager;
import com.vmware.vim25.mo.AuthorizationManager;
import com.vmware.vim25.mo.ClusterProfileManager;
import com.vmware.vim25.mo.CustomFieldsManager;
import com.vmware.vim25.mo.CustomizationSpecManager;
import com.vmware.vim25.mo.DiagnosticManager;
import com.vmware.vim25.mo.DistributedVirtualSwitchManager;
import com.vmware.vim25.mo.EventManager;
import com.vmware.vim25.mo.ExtensionManager;
import com.vmware.vim25.mo.FileManager;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.GuestOperationsManager;
import com.vmware.vim25.mo.HostLocalAccountManager;
import com.vmware.vim25.mo.HostProfileManager;
import com.vmware.vim25.mo.HostSnmpSystem;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.IoFilterManager;
import com.vmware.vim25.mo.IpPoolManager;
import com.vmware.vim25.mo.LicenseManager;
import com.vmware.vim25.mo.LocalizationManager;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.OptionManager;
import com.vmware.vim25.mo.OvfManager;
import com.vmware.vim25.mo.PerformanceManager;
import com.vmware.vim25.mo.ProfileComplianceManager;
import com.vmware.vim25.mo.PropertyCollector;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ScheduledTaskManager;
import com.vmware.vim25.mo.SearchIndex;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.SessionManager;
import com.vmware.vim25.mo.TaskManager;
import com.vmware.vim25.mo.UserDirectory;
import com.vmware.vim25.mo.ViewManager;
import com.vmware.vim25.mo.VirtualDiskManager;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineCompatibilityChecker;
import com.vmware.vim25.mo.VirtualMachineProvisioningChecker;
import com.vmware.vim25.mo.util.MorUtil;
import com.vmware.vim25.ws.Client;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;

public class ServiceInstance
extends ManagedObject {
    private ServiceContent serviceContent = null;
    private static Logger log = Logger.getLogger(ServiceInstance.class);
    static final ManagedObjectReference SERVICE_INSTANCE_MOR = new ManagedObjectReference();
    public static final String VIM25_NAMESPACE = " xmlns=\"urn:vim25\">";
    public static final String VIM20_NAMESPACE = " xmlns=\"urn:vim2\">";

    public ServiceInstance(URL url, String username, String password) throws RemoteException, MalformedURLException {
        this(url, username, password, false);
    }

    public ServiceInstance(URL url, String username, String password, boolean ignoreCert) throws RemoteException, MalformedURLException {
        this(url, username, password, ignoreCert, VIM25_NAMESPACE);
    }

    public ServiceInstance(URL url, String username, String password, TrustManager trustManager) throws RemoteException, MalformedURLException {
        this(url, username, password, trustManager, VIM25_NAMESPACE);
    }

    public ServiceInstance(URL url, String username, String password, boolean ignoreCert, String namespace) throws RemoteException, MalformedURLException {
        this.constructServiceInstance(url, username, password, ignoreCert, namespace, 0, 0, null);
    }

    public ServiceInstance(URL url, String username, String password, TrustManager trustManager, String namespace) throws RemoteException, MalformedURLException {
        this.constructServiceInstance(url, username, password, false, namespace, 0, 0, trustManager);
    }

    public ServiceInstance(URL url, String username, String password, int connectTimeout, int readTimeout) throws RemoteException, MalformedURLException {
        this(url, username, password, false, connectTimeout, readTimeout);
    }

    public ServiceInstance(URL url, String username, String password, boolean ignoreCert, int connectTimeout, int readTimeout) throws RemoteException, MalformedURLException {
        this(url, username, password, ignoreCert, VIM25_NAMESPACE, connectTimeout, readTimeout);
    }

    public ServiceInstance(URL url, String username, String password, TrustManager trustManager, int connectTimeout, int readTimeout) throws RemoteException, MalformedURLException {
        this(url, username, password, trustManager, VIM25_NAMESPACE, connectTimeout, readTimeout);
    }

    public ServiceInstance(URL url, String username, String password, boolean ignoreCert, String namespace, int connectTimeout, int readTimeout) throws RemoteException, MalformedURLException {
        this.constructServiceInstance(url, username, password, ignoreCert, namespace, connectTimeout, readTimeout, null);
    }

    public ServiceInstance(URL url, String username, String password, TrustManager trustManager, String namespace, int connectTimeout, int readTimeout) throws RemoteException, MalformedURLException {
        this.constructServiceInstance(url, username, password, false, namespace, connectTimeout, readTimeout, trustManager);
    }

    protected void constructServiceInstance(URL url, String username, String password, boolean ignoreCert, String namespace, int connectTimeout, int readTimeout, TrustManager trustManager) throws RemoteException, MalformedURLException {
        if (url == null || username == null) {
            throw new NullPointerException("None of url, username can be null.");
        }
        this.setMOR(SERVICE_INSTANCE_MOR);
        VimPortType vimService = trustManager != null ? new VimPortType(url.toString(), trustManager) : new VimPortType(url.toString(), ignoreCert);
        vimService.getWsc().setVimNameSpace(namespace);
        vimService.getWsc().setConnectTimeout(connectTimeout);
        vimService.getWsc().setReadTimeout(readTimeout);
        this.serviceContent = this.retrieveServiceContent(vimService, SERVICE_INSTANCE_MOR);
        vimService.getWsc().setSoapActionOnApiVersion(this.getApiVersion(this.serviceContent));
        this.serviceContent = this.retrieveServiceContent(vimService, SERVICE_INSTANCE_MOR);
        this.setServerConnection(new ServerConnection(url, vimService, this));
        UserSession userSession = this.login(this.getSessionManager(), username, password, null);
        this.getServerConnection().setUserSession(userSession);
    }

    public ServiceInstance(URL url, String sessionStr, boolean ignoreCert) throws RemoteException, MalformedURLException {
        this(url, sessionStr, ignoreCert, VIM25_NAMESPACE);
    }

    public ServiceInstance(URL url, String sessionStr, TrustManager trustManager) throws RemoteException, MalformedURLException {
        this(url, sessionStr, trustManager, VIM25_NAMESPACE);
    }

    public ServiceInstance(URL url, String sessionStr, boolean ignoreCert, String namespace) throws RemoteException, MalformedURLException {
        this.constructServiceInstance(url, sessionStr, ignoreCert, namespace, 0, 0, null);
    }

    public ServiceInstance(URL url, String sessionStr, TrustManager trustManager, String namespace) throws RemoteException, MalformedURLException {
        this.constructServiceInstance(url, sessionStr, false, namespace, 0, 0, trustManager);
    }

    public ServiceInstance(URL url, String sessionStr, boolean ignoreCert, int connectTimeout, int readTimeout) throws RemoteException, MalformedURLException {
        this(url, sessionStr, ignoreCert, VIM25_NAMESPACE, connectTimeout, readTimeout);
    }

    public ServiceInstance(URL url, String sessionStr, TrustManager trustManager, int connectTimeout, int readTimeout) throws RemoteException, MalformedURLException {
        this(url, sessionStr, trustManager, VIM25_NAMESPACE, connectTimeout, readTimeout);
    }

    public ServiceInstance(URL url, String sessionStr, boolean ignoreCert, String namespace, int connectTimeout, int readTimeout) throws RemoteException, MalformedURLException {
        this.constructServiceInstance(url, sessionStr, ignoreCert, namespace, connectTimeout, readTimeout, null);
    }

    public ServiceInstance(URL url, String sessionStr, TrustManager trustManager, String namespace, int connectTimeout, int readTimeout) throws RemoteException, MalformedURLException {
        this.constructServiceInstance(url, sessionStr, false, namespace, connectTimeout, readTimeout, trustManager);
    }

    protected void constructServiceInstance(URL url, String sessionStr, boolean ignoreCert, String namespace, int connectTimeout, int readTimeout, TrustManager trustManager) throws RemoteException, MalformedURLException {
        if (url == null || sessionStr == null) {
            throw new NullPointerException("None of url, session string can be null.");
        }
        this.setMOR(SERVICE_INSTANCE_MOR);
        VimPortType vimService = trustManager != null ? new VimPortType(url.toString(), trustManager) : new VimPortType(url.toString(), ignoreCert);
        Client wsc = vimService.getWsc();
        wsc.setCookie(sessionStr);
        wsc.setVimNameSpace(namespace);
        vimService.getWsc().setConnectTimeout(connectTimeout);
        vimService.getWsc().setReadTimeout(readTimeout);
        this.serviceContent = this.retrieveServiceContent(vimService, SERVICE_INSTANCE_MOR);
        wsc.setSoapActionOnApiVersion(this.getApiVersion(this.serviceContent));
        this.setServerConnection(new ServerConnection(url, vimService, this));
        this.serviceContent = this.retrieveServiceContent(vimService, SERVICE_INSTANCE_MOR);
        UserSession userSession = this.getCurrentUserSession();
        this.getServerConnection().setUserSession(userSession);
    }

    public ServiceInstance(ServerConnection sc) {
        super(sc, SERVICE_INSTANCE_MOR);
    }

    public Calendar getServerClock() {
        return (Calendar)this.getCurrentProperty("serverClock");
    }

    public Capability getCapability() {
        return (Capability)this.getCurrentProperty("capability");
    }

    public ClusterProfileManager getClusterProfileManager() {
        return (ClusterProfileManager)this.createMO(this.getServiceContent().getClusterProfileManager());
    }

    public Calendar currentTime() throws RuntimeFault, RemoteException {
        return this.getVimService().currentTime(this.getMOR());
    }

    public Folder getRootFolder() {
        return new Folder(this.getServerConnection(), this.getServiceContent().getRootFolder());
    }

    public HostVMotionCompatibility[] queryVMotionCompatibility(VirtualMachine vm, HostSystem[] hosts, String[] compatibility) throws RuntimeFault, RemoteException {
        if (vm == null || hosts == null) {
            throw new IllegalArgumentException("Neither vm or hosts can be null.");
        }
        return this.getVimService().queryVMotionCompatibility(this.getMOR(), vm.getMOR(), MorUtil.createMORs(hosts), compatibility);
    }

    public ProductComponentInfo[] retrieveProductComponents() throws RuntimeFault, RemoteException {
        return this.getVimService().retrieveProductComponents(this.getMOR());
    }

    protected UserSession login(SessionManager sessionManager, String userName, String password, String locale) throws RemoteException {
        return sessionManager.login(userName, password, locale);
    }

    protected UserSession getCurrentUserSession() {
        return (UserSession)this.getSessionManager().getCurrentProperty("currentSession");
    }

    protected ServiceContent retrieveServiceContent(VimPortType vimService, ManagedObjectReference mor) throws RemoteException {
        return vimService.retrieveServiceContent(mor);
    }

    protected ServiceContent retrieveServiceContent() throws RuntimeFault, RemoteException {
        return this.getVimService().retrieveServiceContent(this.getMOR());
    }

    public Event[] validateMigration(VirtualMachine[] vms, VirtualMachinePowerState state, String[] testType, ResourcePool pool, HostSystem host) throws InvalidState, RuntimeFault, RemoteException {
        if (vms == null) {
            throw new IllegalArgumentException("vms must not be null.");
        }
        return this.getVimService().validateMigration(this.getMOR(), MorUtil.createMORs(vms), state, testType, pool == null ? null : pool.getMOR(), host == null ? null : host.getMOR());
    }

    public ServiceContent getServiceContent() {
        if (this.serviceContent == null) {
            try {
                this.serviceContent = this.retrieveServiceContent();
            }
            catch (Exception e) {
                log.debug((Object)"Exception caught trying to retrieveServiceContent.", (Throwable)e);
            }
        }
        return this.serviceContent;
    }

    public int getConnectTimeout() {
        return this.getServerConnection().getVimService().getWsc().getConnectTimeout();
    }

    public int getReadTimeout() {
        return this.getServerConnection().getVimService().getWsc().getReadTimeout();
    }

    public TrustManager getTrustManager() {
        return this.getServerConnection().getVimService().getWsc().getTrustManager();
    }

    protected String getApiVersion(ServiceContent serviceContent) {
        return serviceContent.getAbout().getApiVersion();
    }

    public AboutInfo getAboutInfo() {
        return this.getServiceContent().getAbout();
    }

    public AlarmManager getAlarmManager() {
        return (AlarmManager)this.createMO(this.getServiceContent().getAlarmManager());
    }

    public AuthorizationManager getAuthorizationManager() {
        return (AuthorizationManager)this.createMO(this.getServiceContent().getAuthorizationManager());
    }

    public CustomFieldsManager getCustomFieldsManager() {
        return (CustomFieldsManager)this.createMO(this.getServiceContent().getCustomFieldsManager());
    }

    public CustomizationSpecManager getCustomizationSpecManager() {
        return (CustomizationSpecManager)this.createMO(this.getServiceContent().getCustomizationSpecManager());
    }

    public EventManager getEventManager() {
        return (EventManager)this.createMO(this.getServiceContent().getEventManager());
    }

    public DiagnosticManager getDiagnosticManager() {
        return (DiagnosticManager)this.createMO(this.getServiceContent().getDiagnosticManager());
    }

    public DistributedVirtualSwitchManager getDistributedVirtualSwitchManager() {
        return (DistributedVirtualSwitchManager)this.createMO(this.getServiceContent().getDvSwitchManager());
    }

    public ExtensionManager getExtensionManager() {
        return (ExtensionManager)this.createMO(this.getServiceContent().getExtensionManager());
    }

    public FileManager getFileManager() {
        return (FileManager)this.createMO(this.getServiceContent().getFileManager());
    }

    public GuestOperationsManager getGuestOperationsManager() {
        return (GuestOperationsManager)this.createMO(this.getServiceContent().getGuestOperationsManager());
    }

    public HostLocalAccountManager getAccountManager() {
        return (HostLocalAccountManager)this.createMO(this.getServiceContent().getAccountManager());
    }

    public LicenseManager getLicenseManager() {
        return (LicenseManager)this.createMO(this.getServiceContent().getLicenseManager());
    }

    public LocalizationManager getLocalizationManager() {
        return (LocalizationManager)this.createMO(this.getServiceContent().getLocalizationManager());
    }

    public PerformanceManager getPerformanceManager() {
        return (PerformanceManager)this.createMO(this.getServiceContent().getPerfManager());
    }

    public ProfileComplianceManager getProfileComplianceManager() {
        return (ProfileComplianceManager)this.createMO(this.getServiceContent().getComplianceManager());
    }

    public PropertyCollector getPropertyCollector() {
        return (PropertyCollector)this.createMO(this.getServiceContent().getPropertyCollector());
    }

    public ScheduledTaskManager getScheduledTaskManager() {
        return (ScheduledTaskManager)this.createMO(this.getServiceContent().getScheduledTaskManager());
    }

    public SearchIndex getSearchIndex() {
        return (SearchIndex)this.createMO(this.getServiceContent().getSearchIndex());
    }

    public SessionManager getSessionManager() {
        return (SessionManager)this.createMO(this.getServiceContent().getSessionManager());
    }

    public HostSnmpSystem getHostSnmpSystem() {
        return (HostSnmpSystem)this.createMO(this.getServiceContent().getSnmpSystem());
    }

    public HostProfileManager getHostProfileManager() {
        return (HostProfileManager)this.createMO(this.getServiceContent().getHostProfileManager());
    }

    public IpPoolManager getIpPoolManager() {
        return (IpPoolManager)this.createMO(this.getServiceContent().getIpPoolManager());
    }

    public VirtualMachineProvisioningChecker getVirtualMachineProvisioningChecker() {
        return (VirtualMachineProvisioningChecker)this.createMO(this.getServiceContent().getVmProvisioningChecker());
    }

    public VirtualMachineCompatibilityChecker getVirtualMachineCompatibilityChecker() {
        return (VirtualMachineCompatibilityChecker)this.createMO(this.getServiceContent().getVmCompatibilityChecker());
    }

    public TaskManager getTaskManager() {
        return (TaskManager)this.createMO(this.getServiceContent().getTaskManager());
    }

    public UserDirectory getUserDirectory() {
        return (UserDirectory)this.createMO(this.getServiceContent().getUserDirectory());
    }

    public ViewManager getViewManager() {
        return (ViewManager)this.createMO(this.getServiceContent().getViewManager());
    }

    public VirtualDiskManager getVirtualDiskManager() {
        return (VirtualDiskManager)this.createMO(this.getServiceContent().getVirtualDiskManager());
    }

    public OptionManager getOptionManager() {
        return (OptionManager)this.createMO(this.getServiceContent().getSetting());
    }

    public OvfManager getOvfManager() {
        return (OvfManager)this.createMO(this.getServiceContent().getOvfManager());
    }

    public IoFilterManager getIoFilterManager() {
        return (IoFilterManager)this.createMO(this.getServiceContent().getIoFilterManager());
    }

    private ManagedObject createMO(ManagedObjectReference mor) {
        return MorUtil.createExactManagedObject(this.getServerConnection(), mor);
    }

    static {
        SERVICE_INSTANCE_MOR.set_value("ServiceInstance");
        SERVICE_INSTANCE_MOR.setType("ServiceInstance");
    }
}

