/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.api;

import java.security.Principal;
import java.util.Objects;
import java.util.function.Function;

public class SearchQuery {
    public static final int DEFAULT_MAX_RESULT = 10;
    private String input;
    private int maxResults;
    private Principal principal;
    private Function<String, Boolean> userInRoleFunction;
    private String context;

    public SearchQuery(String input) {
        this.input = Objects.requireNonNull(input);
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input != null ? input.trim() : null;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public void setUserInRoleFunction(Function<String, Boolean> userInRoleFunction) {
        this.userInRoleFunction = userInRoleFunction;
    }

    public boolean isUserInRole(String role) {
        if (this.userInRoleFunction != null) {
            return this.userInRoleFunction.apply(role);
        }
        return false;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }
}

