/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.collectd.MibPropertyAttributeType;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpPropertyExtender;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.config.datacollection.MibObjProperty;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegExPropertyExtender
implements SnmpPropertyExtender {
    private static final Logger LOG = LoggerFactory.getLogger(RegExPropertyExtender.class);
    private static final String SOURCE_TYPE = "source-type";
    private static final String SOURCE_ALIAS = "source-alias";
    private static final String INDEX_PATTERN = "index-pattern";

    @Override
    public SnmpAttribute getTargetAttribute(List<CollectionAttribute> sourceAttributes, SnmpCollectionResource targetResource, MibObjProperty property) {
        AttributeGroupType groupType;
        String sourceType = property.getParameterValue(SOURCE_TYPE);
        if (StringUtils.isBlank((String)sourceType)) {
            LOG.warn("Cannot execute the RegEx property extender because: missing parameter {}", (Object)SOURCE_TYPE);
            return null;
        }
        String sourceAlias = property.getParameterValue(SOURCE_ALIAS);
        if (StringUtils.isBlank((String)sourceAlias)) {
            LOG.warn("Cannot execute the RegEx property extender because: missing parameter {}", (Object)SOURCE_ALIAS);
            return null;
        }
        String indexPattern = property.getParameterValue(INDEX_PATTERN);
        if (StringUtils.isBlank((String)indexPattern)) {
            LOG.warn("Cannot execute the RegEx property extender because: missing parameter {}", (Object)INDEX_PATTERN);
            return null;
        }
        Pattern p = Pattern.compile(indexPattern);
        Matcher m = p.matcher(targetResource.getInstance());
        Optional<CollectionAttribute> target = null;
        if (m.find()) {
            String index = m.group(1);
            target = sourceAttributes.stream().filter(a -> this.matches(sourceType, sourceAlias, index, (CollectionAttribute)a)).findFirst();
        }
        if (target != null && target.isPresent() && (groupType = targetResource.getGroupType(property.getGroupName())) != null) {
            MibPropertyAttributeType type = new MibPropertyAttributeType(targetResource.getResourceType(), property, groupType);
            SnmpValue value = SnmpUtils.getValueFactory().getOctetString(target.get().getStringValue().getBytes());
            return new SnmpAttribute(targetResource, type, value);
        }
        return null;
    }

    private boolean matches(String sourceType, String sourceAlias, String index, CollectionAttribute a) {
        CollectionResource r = a.getResource();
        return a.getName().equals(sourceAlias) && r.getResourceTypeName().equals(sourceType) && r.getInstance().equals(index);
    }
}

