/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.model.ResourcePath;

public final class NodeInfo
extends SnmpCollectionResource {
    private SNMPCollectorEntry m_entry;
    private final int m_nodeId;
    private final CollectionAgent m_agent;

    public NodeInfo(NodeResourceType def, CollectionAgent agent) {
        super(def);
        this.m_agent = agent;
        this.m_nodeId = agent.getNodeId();
    }

    @Override
    public int getSnmpIfType() {
        return -1;
    }

    public ResourcePath getPath() {
        return this.getCollectionAgent().getStorageResourcePath();
    }

    public String toString() {
        return "node[" + this.m_nodeId + "]";
    }

    public void setEntry(SNMPCollectorEntry nodeEntry) {
        this.m_entry = nodeEntry;
    }

    protected SNMPCollectorEntry getEntry() {
        return this.m_entry;
    }

    @Override
    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public String getResourceTypeName() {
        return "node";
    }

    public String getInstance() {
        return null;
    }

    public String getUnmodifiedInstance() {
        return this.getInstance();
    }

    public String getInterfaceLabel() {
        return null;
    }

    public ResourcePath getParent() {
        return this.m_agent.getStorageResourcePath();
    }

    public int getNodeId() {
        return this.m_nodeId;
    }
}

