/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.service;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.api.service.GraphContainerProvider;
import org.opennms.netmgt.graph.api.service.GraphService;
import org.opennms.netmgt.graph.api.service.osgi.GraphContainerProviderRegistration;
import org.opennms.netmgt.graph.service.GraphProviderManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class DefaultGraphService
implements GraphService {
    private List<GraphContainerProvider> graphContainerProviders = new CopyOnWriteArrayList<GraphContainerProvider>();
    private final BundleContext bundleContext;
    private final Map<GraphContainerProvider, ServiceRegistration<GraphContainerProviderRegistration>> serviceRegistrationMap = new ConcurrentHashMap<GraphContainerProvider, ServiceRegistration<GraphContainerProviderRegistration>>();

    public DefaultGraphService() {
        this(null);
    }

    public DefaultGraphService(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public List<GraphContainerInfo> getGraphContainerInfos() {
        return this.graphContainerProviders.stream().map(cp -> cp.getContainerInfo()).collect(Collectors.toList());
    }

    public GraphContainerInfo getGraphContainerInfo(String containerId) {
        return this.getGraphContainerInfos().stream().filter(ci -> ci.getId().equals(containerId)).findAny().orElse(null);
    }

    public GraphContainerInfo getGraphContainerInfoByNamespace(String namespace) {
        Optional<GraphContainerInfo> any = this.getGraphContainerInfos().stream().filter(ci -> ci.getNamespaces().contains(namespace)).findAny();
        return any.orElse(null);
    }

    public GenericGraphContainer getGraphContainer(String containerId) {
        Optional<GraphContainerProvider> any = this.graphContainerProviders.stream().filter(cp -> cp.getContainerInfo().getId().equals(containerId)).findAny();
        if (any.isPresent()) {
            return any.get().loadGraphContainer().asGenericGraphContainer();
        }
        return null;
    }

    public GraphInfo getGraphInfo(String graphNamespace) {
        GraphContainerInfo graphContainerInfo = this.getGraphContainerInfoByNamespace(graphNamespace);
        if (graphContainerInfo != null) {
            return graphContainerInfo.getGraphInfo(graphNamespace);
        }
        return null;
    }

    public GenericGraph getGraph(String containerId, String graphNamespace) {
        GenericGraphContainer graphContainer = this.getGraphContainer(containerId);
        if (graphContainer != null) {
            ImmutableGraph graph = graphContainer.getGraph(graphNamespace);
            if (graph != null) {
                return graph.asGenericGraph();
            }
            return null;
        }
        return null;
    }

    public void onBind(GraphContainerProvider graphContainerProvider, Map<String, String> props) {
        GraphContainerInfo containerInfo = graphContainerProvider.getContainerInfo();
        if (this.getGraphContainerInfo(containerInfo.getId()) != null) {
            throw new IllegalArgumentException("A GraphContainerProvider with id '" + containerInfo.getId() + "' already exists. Ignoring container");
        }
        for (String eachNamespace : containerInfo.getNamespaces()) {
            if (this.getGraphInfo(eachNamespace) == null) continue;
            throw new IllegalArgumentException("A Graph with namespace '" + eachNamespace + "' already exists. Ignoring container.");
        }
        this.graphContainerProviders.add(graphContainerProvider);
        if (this.bundleContext != null) {
            ServiceRegistration serviceRegistration = this.bundleContext.registerService(GraphContainerProviderRegistration.class, () -> graphContainerProvider, new Hashtable<String, String>(GraphProviderManager.getActualProperties(props)));
            this.serviceRegistrationMap.put(graphContainerProvider, (ServiceRegistration<GraphContainerProviderRegistration>)serviceRegistration);
        }
    }

    public void onUnbind(GraphContainerProvider graphContainerProvider, Map<String, String> props) {
        if (graphContainerProvider == null) {
            return;
        }
        this.graphContainerProviders.remove(graphContainerProvider);
        ServiceRegistration<GraphContainerProviderRegistration> serviceRegistration = this.serviceRegistrationMap.remove(graphContainerProvider);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }
}

