/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.endpoints.grafana.rest.internal;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.netmgt.endpoints.grafana.api.Dashboard;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaClient;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaEndpoint;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaEndpointException;
import org.opennms.netmgt.endpoints.grafana.api.GrafanaEndpointService;
import org.opennms.netmgt.endpoints.grafana.rest.GrafanaEndpointRestService;

public class GrafanaEndpointRestServiceImpl
implements GrafanaEndpointRestService {
    private final GrafanaEndpointService grafanaEndpointService;

    public GrafanaEndpointRestServiceImpl(GrafanaEndpointService grafanaEndpointService) {
        this.grafanaEndpointService = Objects.requireNonNull(grafanaEndpointService);
    }

    @Override
    public Response listEndpoints() {
        List endpoints = this.grafanaEndpointService.findEndpoints();
        if (endpoints.isEmpty()) {
            return Response.noContent().build();
        }
        JSONArray resultArray = new JSONArray();
        endpoints.forEach(s -> resultArray.put((Object)new JSONObject(s)));
        return Response.ok().entity((Object)resultArray.toString()).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Override
    public Response deleteAllEndpoints() {
        this.grafanaEndpointService.deleteAllEndpoints();
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @Override
    public Response verifyEndpoint(GrafanaEndpoint grafanaEndpoint) {
        GrafanaClient client;
        if (Strings.isNullOrEmpty((String)grafanaEndpoint.getUid())) {
            GrafanaEndpoint endpointToUse = new GrafanaEndpoint();
            endpointToUse.setApiKey(grafanaEndpoint.getApiKey());
            endpointToUse.setUrl(grafanaEndpoint.getUrl());
            endpointToUse.setConnectTimeout(grafanaEndpoint.getConnectTimeout());
            endpointToUse.setReadTimeout(grafanaEndpoint.getReadTimeout());
            client = this.grafanaEndpointService.getClient(endpointToUse);
        } else {
            client = this.grafanaEndpointService.getClient(grafanaEndpoint.getUid());
        }
        try {
            client.getDashboards();
            return Response.ok().build();
        }
        catch (Exception ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)GrafanaEndpointRestServiceImpl.createErrorObject("Grafana endpoint could not be verified.", "entity").toString()).build();
        }
    }

    @Override
    public Response getEndpoint(Long endpointId) {
        GrafanaEndpoint grafanaEndpoint = this.grafanaEndpointService.getEndpointById(endpointId);
        return Response.ok().entity((Object)new JSONObject((Object)grafanaEndpoint).toString()).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Override
    public Response updateEndpoint(GrafanaEndpoint grafanaEndpoint) {
        try {
            this.grafanaEndpointService.updateEndpoint(grafanaEndpoint);
            return Response.accepted().build();
        }
        catch (GrafanaEndpointException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)GrafanaEndpointRestServiceImpl.createErrorObject(ex).toString()).build();
        }
    }

    @Override
    public Response createEndpoint(GrafanaEndpoint newGrafanaEndpoint) {
        try {
            this.grafanaEndpointService.saveEndpoint(newGrafanaEndpoint);
            return Response.accepted().build();
        }
        catch (GrafanaEndpointException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)GrafanaEndpointRestServiceImpl.createErrorObject(ex).toString()).build();
        }
    }

    @Override
    public Response deleteEndpoint(Long endpointId) {
        try {
            this.grafanaEndpointService.deleteEndpoint(this.grafanaEndpointService.getEndpointById(endpointId));
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        catch (GrafanaEndpointException ex) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)GrafanaEndpointRestServiceImpl.createErrorObject(ex).toString()).build();
        }
    }

    @Override
    public Response listDashboards(String uid) {
        try {
            List dashboards = this.grafanaEndpointService.getClient(uid).getDashboards();
            return Response.ok().entity((Object)new JSONArray((Collection)dashboards).toString()).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (IOException ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)GrafanaEndpointRestServiceImpl.createErrorObject(ex).toString()).build();
        }
    }

    @Override
    public Response getDashboard(String uid, String dashboardId) {
        try {
            Dashboard dashboard = this.grafanaEndpointService.getClient(uid).getDashboardByUid(dashboardId);
            return Response.ok().entity((Object)new JSONObject((Object)dashboard).toString()).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (IOException ex) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)GrafanaEndpointRestServiceImpl.createErrorObject(ex).toString()).build();
        }
    }

    private static JSONObject createErrorObject(Exception ex) {
        return GrafanaEndpointRestServiceImpl.createErrorObject(ex.getMessage(), "entity");
    }

    private static JSONObject createErrorObject(GrafanaEndpointException ex) {
        return GrafanaEndpointRestServiceImpl.createErrorObject(ex.getRawMessage(), ex.getContext());
    }

    private static JSONObject createErrorObject(String message, String context) {
        JSONObject errorObject = new JSONObject().put("message", (Object)message).put("context", (Object)context);
        return errorObject;
    }
}

