/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Attribute;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;

public class ExtendedCommunities
implements Attribute {
    public final List<ExtendedCommunity> extendedCommunities;

    public ExtendedCommunities(ByteBuf buffer, PeerFlags flags) {
        this.extendedCommunities = BufferUtils.repeatRemaining((ByteBuf)buffer, b -> new ExtendedCommunity(b, flags));
    }

    @Override
    public void accept(Attribute.Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("extendedCommunities", this.extendedCommunities).toString();
    }

    public static class ExtendedCommunity {
        public final boolean authoritative;
        public final boolean transitive;
        public final int highType;
        public final int lowType;
        public final Value value;

        public ExtendedCommunity(ByteBuf buffer, PeerFlags flags) {
            int highType = BufferUtils.uint8((ByteBuf)buffer);
            this.authoritative = (highType >> 7 & 1) == 1;
            this.transitive = (highType >> 6 & 1) == 1;
            this.highType = highType & 0x3F;
            this.lowType = BufferUtils.uint8((ByteBuf)buffer);
            this.value = ExtendedCommunity.parseValue(this.authoritative, this.highType, this.lowType, BufferUtils.slice((ByteBuf)buffer, (int)6));
        }

        private static Value parseValue(boolean authoritative, int highType, int lowType, ByteBuf buffer) {
            switch (highType | (authoritative ? 1 : 0) << 7) {
                case 0: {
                    return ExtendedCommunity.parseCommon(buffer, lowType, false, false);
                }
                case 1: {
                    return ExtendedCommunity.parseCommon(buffer, lowType, true, true);
                }
                case 2: {
                    return ExtendedCommunity.parseCommon(buffer, lowType, true, false);
                }
                case 3: {
                    return ExtendedCommunity.parseOpaque(buffer, lowType);
                }
                case 128: {
                    return ExtendedCommunity.parseGeneric(buffer, lowType, false, false);
                }
                case 129: {
                    return ExtendedCommunity.parseGeneric(buffer, lowType, true, true);
                }
                case 130: {
                    return ExtendedCommunity.parseGeneric(buffer, lowType, true, false);
                }
            }
            BmpParser.RATE_LIMITED_LOG.debug("Unknown Extended Community Attribute: {}", (Object)highType);
            return null;
        }

        private static Value parseCommon(ByteBuf buffer, int lowType, boolean globalLarge, boolean globalAddress) {
            String global = globalLarge ? (globalAddress ? InetAddressUtils.toIpAddrString((byte[])BufferUtils.bytes((ByteBuf)buffer, (int)4)) : Long.toString(BufferUtils.uint32((ByteBuf)buffer))) : Integer.toString(BufferUtils.uint16((ByteBuf)buffer));
            String local = globalLarge ? Integer.toString(BufferUtils.uint16((ByteBuf)buffer)) : Long.toString(BufferUtils.uint32((ByteBuf)buffer));
            String value = String.format("%s:%s", global, local);
            switch (lowType) {
                case 2: {
                    return new Value("rt", value);
                }
                case 3: {
                    return new Value("soo", value);
                }
                case 4: {
                    return new Value("link-bw", value);
                }
                case 5: {
                    return new Value("ospf-did", value);
                }
                case 7: {
                    return new Value("ospf-rid", value);
                }
                case 8: {
                    return new Value("colc", value);
                }
                case 9: {
                    return new Value("sas", value);
                }
                case 10: 
                case 16: {
                    return new Value("vpn-id", value);
                }
                case 11: {
                    return new Value("import", value);
                }
                case 12: {
                    return new Value("flowspec-redir", value);
                }
                case 18: {
                    return new Value("p2mp-nh", value);
                }
                case 19: {
                    return new Value("rtr", value);
                }
            }
            BmpParser.RATE_LIMITED_LOG.debug("Unknown Extended Community Attribute: Common: {}", (Object)lowType);
            return null;
        }

        private static Value parseOpaque(ByteBuf buffer, int lowType) {
            switch (lowType) {
                case 0: {
                    BufferUtils.skip((ByteBuf)buffer, (int)5);
                    int state = BufferUtils.uint8((ByteBuf)buffer);
                    switch (state) {
                        case 0: {
                            return new Value("valid", "valid");
                        }
                        case 1: {
                            return new Value("valid", "not found");
                        }
                        case 2: {
                            return new Value("valid", "invalid");
                        }
                    }
                    BmpParser.RATE_LIMITED_LOG.debug("Unknown Extended Community Attribute: Opaque: Origin Validation State: {}", (Object)state);
                    return null;
                }
                case 1: {
                    String value;
                    int poi = BufferUtils.uint8((ByteBuf)buffer);
                    int cid = BufferUtils.uint8((ByteBuf)buffer);
                    long cost = BufferUtils.uint32((ByteBuf)buffer);
                    switch (poi) {
                        case 128: {
                            value = String.format("abs:%s%s", cid, cost);
                            break;
                        }
                        case 129: {
                            value = String.format("igp:%s%s", cid, cost);
                            break;
                        }
                        case 130: {
                            value = String.format("ext:%s%s", cid, cost);
                            break;
                        }
                        case 131: {
                            value = String.format("bgp_id:%s%s", cid, cost);
                            break;
                        }
                        default: {
                            BmpParser.RATE_LIMITED_LOG.debug("Unknown Extended Community Attribute: Opaque: Point of Insertion: {}", (Object)poi);
                            return null;
                        }
                    }
                    return new Value("cost", value);
                }
                case 3: {
                    return new Value("cp-orf", "");
                }
                case 6: {
                    return ExtendedCommunity.parseOspfRouteType(buffer);
                }
                case 11: {
                    BufferUtils.skip((ByteBuf)buffer, (int)2);
                    long color = BufferUtils.uint32((ByteBuf)buffer);
                    return new Value("color", Long.toString(color));
                }
                case 12: {
                    BufferUtils.skip((ByteBuf)buffer, (int)4);
                    int tunnelType = BufferUtils.uint16((ByteBuf)buffer);
                    return new Value("encap", Integer.toString(tunnelType));
                }
                case 13: {
                    return new Value("default-gw", "");
                }
            }
            BmpParser.RATE_LIMITED_LOG.debug("Unknown Extended Community Attribute: Opaque: {}", (Object)lowType);
            return null;
        }

        private static Value parseOspfRouteType(ByteBuf buffer) {
            String value;
            long area = BufferUtils.uint32((ByteBuf)buffer);
            int type = BufferUtils.uint8((ByteBuf)buffer);
            int options = BufferUtils.uint8((ByteBuf)buffer);
            switch (type) {
                case 1: 
                case 2: {
                    value = String.format("%s:O", area);
                    break;
                }
                case 3: {
                    value = String.format("%s:IA", area);
                    break;
                }
                case 5: {
                    value = String.format("0:E:%s", options);
                    break;
                }
                case 7: {
                    value = String.format("%s:N:%s", options);
                    break;
                }
                default: {
                    BmpParser.RATE_LIMITED_LOG.debug("Unknown Extended Community Attribute: Opaque: OSPF Route Type: {}", (Object)type);
                    return null;
                }
            }
            return new Value("ospf-rt", value);
        }

        private static Value parseGeneric(ByteBuf buffer, int lowType, boolean globalLarge, boolean globalAddress) {
            switch (lowType) {
                case 0: {
                    return ExtendedCommunity.parseOspfRouteType(buffer);
                }
                case 1: {
                    long id = BufferUtils.uint32((ByteBuf)buffer);
                    return new Value("ospf-ri", String.format("%s", id));
                }
                case 6: {
                    int global = BufferUtils.uint16((ByteBuf)buffer);
                    long local = BufferUtils.uint32((ByteBuf)buffer);
                    return new Value("flow-rate", String.format("%s:%s", global, local));
                }
                case 7: {
                    BufferUtils.skip((ByteBuf)buffer, (int)5);
                    int actions = BufferUtils.uint8((ByteBuf)buffer);
                    StringBuilder s = new StringBuilder();
                    if ((actions & 2) != 0) {
                        s.append('S');
                    }
                    if ((actions & 1) != 0) {
                        s.append('T');
                    }
                    return new Value("flow-act", s.toString());
                }
                case 8: {
                    String global = globalLarge ? (globalAddress ? InetAddressUtils.toIpAddrString((byte[])BufferUtils.bytes((ByteBuf)buffer, (int)4)) : Long.toString(BufferUtils.uint32((ByteBuf)buffer))) : Integer.toString(BufferUtils.uint16((ByteBuf)buffer));
                    String local = globalLarge ? Integer.toString(BufferUtils.uint16((ByteBuf)buffer)) : Long.toString(BufferUtils.uint32((ByteBuf)buffer));
                    return new Value("flow-redir", String.format("%s:%s", global, local));
                }
                case 9: {
                    BufferUtils.skip((ByteBuf)buffer, (int)5);
                    int remark = BufferUtils.uint8((ByteBuf)buffer);
                    return new Value("flow-remark", String.format("%s", remark));
                }
                case 10: {
                    int encap = BufferUtils.uint8((ByteBuf)buffer);
                    int flags = BufferUtils.uint8((ByteBuf)buffer);
                    int mtu = BufferUtils.uint16((ByteBuf)buffer);
                    return new Value("l2info", String.format("%s:%s:%s", encap, flags, mtu));
                }
            }
            BmpParser.RATE_LIMITED_LOG.debug("Unknown Extended Community Attribute: Generic: {}", (Object)lowType);
            return null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("authoritative", this.authoritative).add("transitive", this.transitive).add("highType", this.highType).add("lowType", this.lowType).add("value", (Object)this.value).toString();
        }

        public static class Value {
            public final String type;
            public final String value;

            public Value(String type, String value) {
                this.type = Objects.requireNonNull(type);
                this.value = Objects.requireNonNull(value);
            }
        }
    }
}

