/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.util.concurrent.atomic.AtomicLong;
import org.asteriskjava.fastagi.AgiServer;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AgiServerThread {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static AtomicLong idCounter = new AtomicLong();
    private AgiServer agiServer;
    private Thread thread;
    private boolean daemon = true;

    public AgiServerThread() {
    }

    public AgiServerThread(AgiServer agiServer) {
        this.agiServer = agiServer;
    }

    public void setAgiServer(AgiServer agiServer) {
        this.agiServer = agiServer;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public synchronized void startup() throws IllegalStateException, RuntimeException {
        if (this.agiServer == null) {
            throw new IllegalStateException("Mandatory property agiServer is not set.");
        }
        if (this.thread != null) {
            throw new IllegalStateException("AgiServer is already started");
        }
        this.thread = this.createThread();
        this.thread.start();
    }

    protected Thread createThread() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AgiServerThread.this.agiServer.startup();
                }
                catch (Throwable e) {
                    throw new RuntimeException("Exception running AgiServer.", e);
                }
            }
        });
        t.setName("Asterisk-Java AgiServer-" + idCounter.getAndIncrement());
        t.setDaemon(this.daemon);
        t.setUncaughtExceptionHandler(new AgiThreadUncaughtExceptionHanlder());
        return t;
    }

    public synchronized void shutdown() throws IllegalStateException {
        if (this.agiServer == null) {
            throw new IllegalStateException("Mandatory property agiServer is not set.");
        }
        this.agiServer.shutdown();
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted while waiting for AgiServer to shutdown.");
                Thread.currentThread().interrupt();
            }
            this.thread = null;
        }
    }

    class AgiThreadUncaughtExceptionHanlder
    implements Thread.UncaughtExceptionHandler {
        AgiThreadUncaughtExceptionHanlder() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            AgiServerThread.this.logger.error("Uncaught exception in AgiServerThread", e);
        }
    }
}

