/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.collection;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptException;
import org.opennms.core.fileutils.FileUpdateCallback;
import org.opennms.core.fileutils.FileUpdateWatcher;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.protocols.collection.AbstractCollectionAdapter;
import org.opennms.netmgt.telemetry.protocols.collection.ScriptedCollectionSetBuilder;
import org.osgi.framework.BundleContext;

public abstract class AbstractScriptedCollectionAdapter
extends AbstractCollectionAdapter {
    private FileUpdateWatcher scriptUpdateWatcher;
    private String script;
    private final ThreadLocal<ScriptedCollectionSetBuilder> scriptedCollectionSetBuilders = new ThreadLocal<ScriptedCollectionSetBuilder>(){

        @Override
        protected ScriptedCollectionSetBuilder initialValue() {
            try {
                return AbstractScriptedCollectionAdapter.this.loadCollectionBuilder(AbstractScriptedCollectionAdapter.this.bundleContext, AbstractScriptedCollectionAdapter.this.script);
            }
            catch (Exception e) {
                AbstractScriptedCollectionAdapter.this.LOG.error("Failed to create builder for script '{}'.", (Object)AbstractScriptedCollectionAdapter.this.script, (Object)e);
                return null;
            }
        }
    };
    private ThreadLocal<Boolean> scriptCompiled = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private Map<ScriptedCollectionSetBuilder, Boolean> scriptUpdateMap = new ConcurrentHashMap<ScriptedCollectionSetBuilder, Boolean>();

    public AbstractScriptedCollectionAdapter(AdapterDefinition adapterConfig, MetricRegistry metricRegistry) {
        super(adapterConfig, metricRegistry);
    }

    protected ScriptedCollectionSetBuilder getCollectionBuilder() {
        ScriptedCollectionSetBuilder builder = this.scriptedCollectionSetBuilders.get();
        if (builder != null && this.scriptUpdateMap.get(builder).booleanValue() || !this.scriptCompiled.get().booleanValue()) {
            this.scriptedCollectionSetBuilders.remove();
            builder = this.scriptedCollectionSetBuilders.get();
        }
        if (builder == null) {
            this.scriptCompiled.set(false);
            return null;
        }
        if (!this.scriptCompiled.get().booleanValue()) {
            this.scriptCompiled.set(true);
        }
        return builder;
    }

    private ScriptedCollectionSetBuilder loadCollectionBuilder(BundleContext bundleContext, String script) throws IOException, ScriptException {
        if (bundleContext != null) {
            ScriptedCollectionSetBuilder builder = new ScriptedCollectionSetBuilder(new File(script), bundleContext);
            this.scriptUpdateMap.put(builder, false);
            return builder;
        }
        ScriptedCollectionSetBuilder builder = new ScriptedCollectionSetBuilder(new File(script));
        this.scriptUpdateMap.put(builder, false);
        return builder;
    }

    private ScriptedCollectionSetBuilder checkScript(BundleContext bundleContext, String script) throws IOException, ScriptException {
        if (bundleContext != null) {
            return new ScriptedCollectionSetBuilder(new File(script), bundleContext);
        }
        return new ScriptedCollectionSetBuilder(new File(script));
    }

    private void setFileUpdateCallback(String script) {
        if (!Strings.isNullOrEmpty((String)script)) {
            try {
                this.scriptUpdateWatcher = new FileUpdateWatcher(script, this.reloadScript());
            }
            catch (Exception e) {
                this.LOG.info("Script reload Utils is not registered", (Throwable)e);
            }
        }
    }

    private FileUpdateCallback reloadScript() {
        return new FileUpdateCallback(){

            public void reload() {
                try {
                    AbstractScriptedCollectionAdapter.this.checkScript(AbstractScriptedCollectionAdapter.this.bundleContext, AbstractScriptedCollectionAdapter.this.script);
                    AbstractScriptedCollectionAdapter.this.LOG.debug("Updated script compiled");
                    AbstractScriptedCollectionAdapter.this.scriptUpdateMap.replaceAll((builder, Boolean2) -> true);
                }
                catch (Exception e) {
                    AbstractScriptedCollectionAdapter.this.LOG.error("Updated script failed to build, using existing script'{}'.", (Object)AbstractScriptedCollectionAdapter.this.script, (Object)e);
                }
            }
        };
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
        this.setFileUpdateCallback(script);
    }

    @Override
    public void destroy() {
        if (this.scriptUpdateWatcher != null) {
            this.scriptUpdateWatcher.destroy();
        }
    }
}

