/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.impl;

import com.google.common.base.Preconditions;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexlEvaluateFunctions {
    private static final Logger LOG = LoggerFactory.getLogger(JexlEvaluateFunctions.class);
    private JexlEngine m_jexl;
    private JexlContext m_context = null;

    public JexlEvaluateFunctions(JexlContext context, JexlEngine jexl) {
        this.m_context = (JexlContext)Preconditions.checkNotNull((Object)context, (Object)"JexlContext context");
        this.m_jexl = (JexlEngine)Preconditions.checkNotNull((Object)jexl, (Object)"JexlEngine jexl");
    }

    public Double evaluate(String formula) {
        try {
            return (Double)this.m_jexl.createExpression(formula).evaluate(this.m_context);
        }
        catch (Exception ex) {
            LOG.error("jexl:evaluate problem evaluating string formula '" + formula + "'", (Throwable)ex);
            return Double.NaN;
        }
    }
}

