/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jrobin.core.RrdException;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.impl.AbstractRrdBasedFetchStrategy;
import org.opennms.netmgt.measurements.impl.Utils;
import org.opennms.netmgt.measurements.model.QueryMetadata;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.rrd.jrrd2.api.JRrd2;
import org.opennms.netmgt.rrd.jrrd2.api.JRrd2Exception;
import org.opennms.netmgt.rrd.jrrd2.impl.JRrd2Jni;

public class JRrd2FetchStrategy
extends AbstractRrdBasedFetchStrategy {
    private JRrd2 jrrd2 = new JRrd2Jni();

    @Override
    protected FetchResults fetchMeasurements(long start, long end, long step, int maxrows, Map<Source, String> rrdsBySource, Map<String, Object> constants, QueryMetadata metadata) throws RrdException {
        org.opennms.netmgt.rrd.jrrd2.api.FetchResults xportResults;
        long startInSeconds = (long)Math.floor((double)start / 1000.0);
        long endInSeconds = (long)Math.floor((double)end / 1000.0);
        long stepInSeconds = (long)Math.floor((double)step / 1000.0);
        if (stepInSeconds <= 0L) {
            stepInSeconds = 1L;
        }
        HashMap labelMap = Maps.newHashMap();
        int k = 0;
        LinkedList argv = Lists.newLinkedList();
        for (Map.Entry<Source, String> entry : rrdsBySource.entrySet()) {
            Source source = entry.getKey();
            String rrdFile = entry.getValue();
            String tempLabel = Integer.toString(++k);
            labelMap.put(tempLabel, source.getLabel());
            if (source.getEffectiveDataSource().length() > 19) {
                source.setDataSource(source.getEffectiveDataSource().substring(0, 19));
            }
            argv.add(String.format("DEF:%s=%s:%s:%s", tempLabel, Utils.escapeColons(rrdFile), Utils.escapeColons(source.getEffectiveDataSource()), source.getAggregation()));
            argv.add(String.format("XPORT:%s:%s", tempLabel, tempLabel));
        }
        try {
            xportResults = this.jrrd2.xport(startInSeconds, endInSeconds, stepInSeconds, (long)maxrows, argv.toArray(new String[argv.size()]));
        }
        catch (JRrd2Exception e) {
            throw new RrdException("Xport failed.", (Throwable)e);
        }
        long[] timestamps = xportResults.getTimestamps();
        int i = 0;
        while (i < timestamps.length) {
            int n = i++;
            timestamps[n] = timestamps[n] * 1000L;
        }
        Map valuesByTempLabel = xportResults.getColumnsWithValues();
        LinkedHashMap valuesByLabel = Maps.newLinkedHashMap();
        for (Map.Entry entry : valuesByTempLabel.entrySet()) {
            valuesByLabel.put((String)labelMap.get(entry.getKey()), (double[])entry.getValue());
        }
        return new FetchResults(timestamps, (Map)valuesByLabel, xportResults.getStep() * 1000L, constants, metadata);
    }
}

