/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl.holtwinters;

import java.util.Arrays;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersSeasonalEstimatesValidator;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersSeasonalityType;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersTrainingMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class HoltWintersPointForecasterParams {
    private static final Logger LOG = LoggerFactory.getLogger(HoltWintersPointForecasterParams.class);
    private HoltWintersSeasonalityType seasonalityType = HoltWintersSeasonalityType.MULTIPLICATIVE;
    private int frequency = 0;
    private double alpha = 0.15;
    private double beta = 0.15;
    private double gamma = 0.15;
    private int warmUpPeriod = 0;
    private double initLevelEstimate = Double.NaN;
    private double initBaseEstimate = Double.NaN;
    private double[] initSeasonalEstimates = new double[0];
    private HoltWintersTrainingMethod initTrainingMethod = HoltWintersTrainingMethod.NONE;
    private final HoltWintersSeasonalEstimatesValidator seasonalEstimatesValidator = new HoltWintersSeasonalEstimatesValidator();

    public boolean isMultiplicative() {
        return this.seasonalityType.equals((Object)HoltWintersSeasonalityType.MULTIPLICATIVE);
    }

    public int calculateInitTrainingPeriod() {
        return this.initTrainingMethod == HoltWintersTrainingMethod.SIMPLE ? this.frequency * 2 : 0;
    }

    public void validate() {
        Assert.notNull((Object)((Object)this.seasonalityType), (String)("Required: seasonalityType one of " + Arrays.toString((Object[])HoltWintersSeasonalityType.values())));
        Assert.notNull((Object)((Object)this.initTrainingMethod), (String)("Required: initTrainingMethod one of " + Arrays.toString((Object[])HoltWintersTrainingMethod.values())));
        Assert.isTrue((0 < this.frequency ? 1 : 0) != 0, (String)"Required: frequency value greater than 0");
        Assert.isTrue((0.0 <= this.alpha && this.alpha <= 1.0 ? 1 : 0) != 0, (String)"Required: alpha in the range [0, 1]");
        Assert.isTrue((0.0 <= this.beta && this.beta <= 1.0 ? 1 : 0) != 0, (String)"Required: beta in the range [0, 1]");
        Assert.isTrue((0.0 <= this.gamma && this.gamma <= 1.0 ? 1 : 0) != 0, (String)"Required: gamma in the range [0, 1]");
        this.validateInitTrainingMethod();
        this.validateInitSeasonalEstimates();
    }

    private void validateInitTrainingMethod() {
        int minWarmUpPeriod;
        if (this.initTrainingMethod == HoltWintersTrainingMethod.SIMPLE && this.warmUpPeriod < (minWarmUpPeriod = this.calculateInitTrainingPeriod())) {
            LOG.warn(String.format("warmUpPeriod (%d) should be greater than or equal to (frequency * 2) (%d), as the detector will not emit anomalies during training. Setting warmUpPeriod to %d.", this.warmUpPeriod, minWarmUpPeriod, minWarmUpPeriod));
            this.warmUpPeriod = minWarmUpPeriod;
        }
    }

    private void validateInitSeasonalEstimates() {
        this.seasonalEstimatesValidator.validate(this.initSeasonalEstimates, this.frequency, this.seasonalityType);
    }

    public HoltWintersSeasonalityType getSeasonalityType() {
        return this.seasonalityType;
    }

    public HoltWintersPointForecasterParams setSeasonalityType(HoltWintersSeasonalityType seasonalityType) {
        this.seasonalityType = seasonalityType;
        return this;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public HoltWintersPointForecasterParams setFrequency(int frequency) {
        this.frequency = frequency;
        return this;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public HoltWintersPointForecasterParams setAlpha(double alpha) {
        this.alpha = alpha;
        return this;
    }

    public double getBeta() {
        return this.beta;
    }

    public HoltWintersPointForecasterParams setBeta(double beta) {
        this.beta = beta;
        return this;
    }

    public double getGamma() {
        return this.gamma;
    }

    public HoltWintersPointForecasterParams setGamma(double gamma) {
        this.gamma = gamma;
        return this;
    }

    public int getWarmUpPeriod() {
        return this.warmUpPeriod;
    }

    public HoltWintersPointForecasterParams setWarmUpPeriod(int warmUpPeriod) {
        this.warmUpPeriod = warmUpPeriod;
        return this;
    }

    public double getInitLevelEstimate() {
        return this.initLevelEstimate;
    }

    public void setInitLevelEstimate(double initLevelEstimate) {
        this.initLevelEstimate = initLevelEstimate;
    }

    public double getInitBaseEstimate() {
        return this.initBaseEstimate;
    }

    public void setInitBaseEstimate(double initBaseEstimate) {
        this.initBaseEstimate = initBaseEstimate;
    }

    public double[] getInitSeasonalEstimates() {
        return this.initSeasonalEstimates;
    }

    public void setInitSeasonalEstimates(double[] initSeasonalEstimates) {
        this.initSeasonalEstimates = initSeasonalEstimates;
    }

    public HoltWintersTrainingMethod getInitTrainingMethod() {
        return this.initTrainingMethod;
    }

    public HoltWintersPointForecasterParams setInitTrainingMethod(HoltWintersTrainingMethod initTrainingMethod) {
        this.initTrainingMethod = initTrainingMethod;
        return this;
    }
}

