/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl.holtwinters;

import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersException;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersOnlineAlgorithm;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersOnlineComponents;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersPointForecasterParams;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersSimpleTrainingModel;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.PointForecast;
import org.springframework.util.Assert;

public class HoltWintersPointForecaster {
    private HoltWintersPointForecasterParams params;
    private HoltWintersOnlineComponents components;
    private HoltWintersSimpleTrainingModel holtWintersSimpleTrainingModel;
    private HoltWintersOnlineAlgorithm holtWintersOnlineAlgorithm;

    public HoltWintersPointForecaster(HoltWintersPointForecasterParams params) {
        Assert.notNull((Object)params, (String)"params can't be null");
        params.validate();
        this.params = params;
        this.components = new HoltWintersOnlineComponents(params);
        this.holtWintersOnlineAlgorithm = new HoltWintersOnlineAlgorithm();
        this.holtWintersSimpleTrainingModel = new HoltWintersSimpleTrainingModel(params);
        double initForecast = this.holtWintersOnlineAlgorithm.getForecast(params.getSeasonalityType(), this.components.getLevel(), this.components.getBase(), this.components.getSeasonal(this.components.getCurrentSeasonalIndex()));
        this.components.setForecast(initForecast);
    }

    public PointForecast forecast(double observed) {
        try {
            double prevForecast = this.components.getForecast();
            this.trainOrObserve(observed);
            return new PointForecast(prevForecast, this.stillWarmingUp());
        }
        catch (Exception e) {
            throw new HoltWintersException(String.format("Exception occurred during classification. %s: \"%s\"", e.getClass(), e.getMessage()), e);
        }
    }

    public boolean isInitialTrainingComplete() {
        switch (this.params.getInitTrainingMethod()) {
            case NONE: {
                return true;
            }
            case SIMPLE: {
                return this.holtWintersSimpleTrainingModel.isTrainingComplete(this.params);
            }
        }
        throw new IllegalStateException(String.format("Unexpected training method '%s'", new Object[]{this.params.getInitTrainingMethod()}));
    }

    private void trainOrObserve(double observed) {
        if (!this.isInitialTrainingComplete()) {
            this.holtWintersSimpleTrainingModel.observeAndTrain(observed, this.params, this.components);
        } else {
            this.holtWintersOnlineAlgorithm.observeValueAndUpdateForecast(observed, this.params, this.components);
        }
    }

    private boolean stillWarmingUp() {
        return this.components.getN() <= (long)this.params.getWarmUpPeriod();
    }
}

