/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl.holtwinters;

import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersOnlineComponents;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersPointForecasterParams;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersSeasonalityType;

public class HoltWintersOnlineAlgorithm {
    public void observeValueAndUpdateForecast(double y, HoltWintersPointForecasterParams params, HoltWintersOnlineComponents components) {
        double newSeason;
        double newBase;
        double newLevel;
        double alpha = params.getAlpha();
        double beta = params.getBeta();
        double gamma = params.getGamma();
        boolean multiplicative = params.isMultiplicative();
        double prevLevel = components.getLevel();
        double prevBase = components.getBase();
        int seasonalIdx = components.getCurrentSeasonalIndex();
        double season = components.getSeasonal(seasonalIdx);
        if (multiplicative) {
            newLevel = alpha * (y / season) + (1.0 - alpha) * (prevLevel + prevBase);
            newBase = beta * (newLevel - prevLevel) + (1.0 - beta) * prevBase;
            newSeason = gamma * (y / (prevLevel + prevBase)) + (1.0 - gamma) * season;
        } else {
            newLevel = alpha * (y - season) + (1.0 - alpha) * (prevLevel + prevBase);
            newBase = beta * (newLevel - prevLevel) + (1.0 - beta) * prevBase;
            newSeason = gamma * (y - prevLevel - prevBase) + (1.0 - gamma) * season;
        }
        this.updateComponents(components, y, newLevel, newBase, newSeason, seasonalIdx);
        this.observeValue(components, y);
        double nextSeason = components.getSeasonal(components.getCurrentSeasonalIndex());
        this.updateForecast(components, this.getForecast(params.getSeasonalityType(), newLevel, newBase, nextSeason));
    }

    public double getForecast(HoltWintersSeasonalityType seasonalityType, double level, double base, double season) {
        return HoltWintersSeasonalityType.MULTIPLICATIVE.equals((Object)seasonalityType) ? (level + base) * season : level + base + season;
    }

    private void updateComponents(HoltWintersOnlineComponents components, double y, double newLevel, double newBase, double newSeason, int seasonalIdx) {
        components.setLevel(newLevel);
        components.setBase(newBase);
        components.setSeasonal(seasonalIdx, newSeason, y);
    }

    private void updateForecast(HoltWintersOnlineComponents components, double newForecast) {
        components.setForecast(newForecast);
    }

    private void observeValue(HoltWintersOnlineComponents components, double y) {
        components.addValue(y);
    }
}

