/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Set;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class LDAPBackupResponse
extends LDAPExtendedResponse {
    private int bufferLength;
    private String stateInfo;
    private String chunkSizesString;
    private byte[] returnedBuffer;

    public LDAPBackupResponse(RfcLDAPMessage rfcLDAPMessage) throws IOException {
        super(rfcLDAPMessage);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = null;
        if (this.getID() == null || !this.getID().equals("2.16.840.1.113719.1.27.100.97")) {
            throw new IOException("LDAP Extended Operation not supported");
        }
        if (this.getResultCode() == 0) {
            int n4;
            byte[] byArray = this.getValue();
            if (byArray == null) {
                throw new IOException("LDAP Operations error. No returned value.");
            }
            LBERDecoder lBERDecoder = new LBERDecoder();
            if (lBERDecoder == null) {
                throw new IOException("Decoding error");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1Integer aSN1Integer = (ASN1Integer)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1Integer == null) {
                throw new IOException("Decoding error");
            }
            this.bufferLength = aSN1Integer.intValue();
            ASN1Integer aSN1Integer2 = (ASN1Integer)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1Integer2 == null) {
                throw new IOException("Decoding error");
            }
            n = aSN1Integer2.intValue();
            ASN1Integer aSN1Integer3 = (ASN1Integer)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1Integer3 == null) {
                throw new IOException("Decoding error");
            }
            n2 = aSN1Integer3.intValue();
            this.stateInfo = n + "+" + n2;
            ASN1OctetString aSN1OctetString = (ASN1OctetString)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1OctetString == null) {
                throw new IOException("Decoding error");
            }
            this.returnedBuffer = aSN1OctetString.byteValue();
            ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1Sequence == null) {
                throw new IOException("Decoding error");
            }
            n3 = ((ASN1Integer)aSN1Sequence.get(0)).intValue();
            nArray = new int[n3];
            ASN1Set aSN1Set = (ASN1Set)aSN1Sequence.get(1);
            for (int i = 0; i < n3; ++i) {
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Set.get(i);
                nArray[i] = ((ASN1Integer)aSN1Sequence2.get(0)).intValue();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(n3);
            stringBuffer.append(";");
            for (n4 = 0; n4 < n3 - 1; ++n4) {
                stringBuffer.append(nArray[n4]);
                stringBuffer.append(";");
            }
            stringBuffer.append(nArray[n4]);
            this.chunkSizesString = stringBuffer.toString();
        } else {
            this.bufferLength = 0;
            this.stateInfo = null;
            this.chunkSizesString = null;
            this.returnedBuffer = null;
        }
    }

    public int getBufferLength() {
        return this.bufferLength;
    }

    public String getStatusInfo() {
        return this.stateInfo;
    }

    public String getChunkSizesString() {
        return this.chunkSizesString;
    }

    public byte[] getReturnedBuffer() {
        return this.returnedBuffer;
    }
}

