/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.persistence.tcp;

import java.util.Set;
import org.opennms.netmgt.collection.api.AbstractPersister;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.PersistOperationBuilder;
import org.opennms.netmgt.collection.api.ResourceIdentifier;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.tcp.TcpOutputStrategy;
import org.opennms.netmgt.collection.persistence.tcp.TcpPersistOperationBuilder;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpBasePersister
extends AbstractPersister {
    protected static final Logger LOG = LoggerFactory.getLogger(TcpBasePersister.class);
    private final TcpOutputStrategy m_tcpStrategy;
    private TcpPersistOperationBuilder m_builder;

    protected TcpBasePersister(ServiceParameters params, RrdRepository repository, TcpOutputStrategy tcpStrategy) {
        super(params, repository);
        this.m_tcpStrategy = tcpStrategy;
    }

    protected void persistStringAttribute(ResourcePath path, String key, String value) {
        this.m_builder.setStringAttributeValue(key, value);
    }

    protected TcpPersistOperationBuilder createBuilder(CollectionResource resource, String name, Set<CollectionAttributeType> attributeTypes) {
        TcpPersistOperationBuilder builder = new TcpPersistOperationBuilder(this.getTcpStrategy(), (ResourceIdentifier)resource, name);
        if (resource.getTimeKeeper() != null) {
            builder.setTimeKeeper(resource.getTimeKeeper());
        }
        return builder;
    }

    protected void setBuilder(TcpPersistOperationBuilder builder) {
        this.m_builder = builder;
        super.setBuilder((PersistOperationBuilder)builder);
    }

    public TcpOutputStrategy getTcpStrategy() {
        return this.m_tcpStrategy;
    }
}

